/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import lotr.common.LOTRGameRules;
import lotr.common.LOTRLog;
import lotr.common.block.FallenLeavesBlock;
import lotr.common.block.HangingWebBlock;
import lotr.common.block.PlateBlock;
import lotr.common.block.ReedsBlock;
import lotr.common.block.SnowPathBlock;
import lotr.common.block.ThatchBlock;
import lotr.common.block.ThatchSlabBlock;
import lotr.common.block.ThatchStairsBlock;
import lotr.common.block.VerticalOnlySlabBlock;
import lotr.common.block.trees.BirchTreeAlt;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.MiscDataModule;
import lotr.common.data.RespawnDataModule;
import lotr.common.dim.LOTRDimension;
import lotr.common.event.SpeechGarbler;
import lotr.common.init.LOTRDimensions;
import lotr.common.init.LOTRItems;
import lotr.common.init.LOTRTags;
import lotr.common.init.LOTRWorldTypes;
import lotr.common.item.EmptyVesselItem;
import lotr.common.item.RedBookItem;
import lotr.common.item.VesselDrinkItem;
import lotr.common.item.VesselType;
import lotr.common.time.LOTRDate;
import lotr.common.time.LOTRTime;
import lotr.common.util.LOTRUtil;
import lotr.common.world.RingPortalTeleporter;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.fac.FactionSettingsManager;
import lotr.common.world.map.CustomWaypointStructureHandler;
import lotr.common.world.map.MapSettingsManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.HorseInventoryContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.HangingEntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.PistonEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class LOTREventHandler {
    private final SpeechGarbler speechGarbler = new SpeechGarbler();
    private static final int BED_RESPAWN_WITHIN = 5000;
    private static final int WORLDSPAWN_RESPAWN_WITHIN = 2000;
    private static final int MIN_RESPAWN_RANGE = 500;
    private static final int MAX_RESPAWN_RANGE = 1500;

    public LOTREventHandler() {
        this.registerHandlers(this);
    }

    private void registerHandlers(Object ... handlers) {
        for (Object handler : handlers) {
            FMLJavaModLoadingContext.get().getModEventBus().register(handler);
            MinecraftForge.EVENT_BUS.register(handler);
        }
    }

    @SubscribeEvent
    public void getBurnTime(FurnaceFuelBurnTimeEvent event) {
        ItemStack itemstack = event.getItemStack();
        Item item = itemstack.func_77973_b();
        if (item.func_206844_a(LOTRTags.Items.WOODEN_BEAMS)) {
            event.setBurnTime(300);
            return;
        }
        if (item.func_206844_a(LOTRTags.Items.WOODEN_BEAM_SLABS)) {
            event.setBurnTime(150);
            return;
        }
        if (item.func_206844_a(LOTRTags.Items.LOG_SLABS)) {
            event.setBurnTime(150);
            return;
        }
        if (item.func_206844_a(LOTRTags.Items.LOG_STAIRS)) {
            event.setBurnTime(300);
            return;
        }
        if (item.func_206844_a(LOTRTags.Items.BRANCHES)) {
            event.setBurnTime(300);
            return;
        }
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).func_179223_d();
            if (block instanceof ReedsBlock) {
                event.setBurnTime(100);
                return;
            }
            if (block instanceof ThatchBlock) {
                event.setBurnTime(100);
                return;
            }
            if (block instanceof ThatchSlabBlock) {
                event.setBurnTime(50);
                return;
            }
            if (block instanceof ThatchStairsBlock) {
                event.setBurnTime(67);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            MiscDataModule miscData;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            LOTRLevelData levelData = LOTRLevelData.serverInstance();
            MapSettingsManager.serverInstance().sendMapToPlayer(serverPlayer);
            FactionSettingsManager.serverInstance().sendFactionsToPlayer(serverPlayer);
            if (world.func_175624_G() instanceof LOTRWorldTypes.LOTRWorldTypeMiddleEarth && serverPlayer.field_71093_bK == DimensionType.field_223227_a_ && !(miscData = levelData.getData((PlayerEntity)serverPlayer).getMiscData()).getInitialSpawnedIntoME()) {
                RingPortalTeleporter.transferEntity((Entity)serverPlayer, false);
                miscData.setInitialSpawnedIntoME(true);
            }
            levelData.sendLoginPacket(serverPlayer);
            levelData.playerDataHandleLogin(serverPlayer);
            LOTRDate.sendUpdatePacket(serverPlayer, false);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K && player.func_184187_bx() instanceof AbstractChestedHorseEntity) {
            AbstractChestedHorseEntity logoutHorse = (AbstractChestedHorseEntity)player.func_184187_bx();
            double checkRange = 64.0;
            List nearbyPlayers = world.func_217357_a(PlayerEntity.class, player.func_174813_aQ().func_72321_a(checkRange, checkRange, checkRange));
            for (PlayerEntity otherPlayer : nearbyPlayers) {
                HorseInventoryContainer horseInv;
                AbstractHorseEntity openHorse;
                if (otherPlayer == player || !(otherPlayer.field_71070_bA instanceof HorseInventoryContainer) || (openHorse = (AbstractHorseEntity)ObfuscationReflectionHelper.getPrivateValue(HorseInventoryContainer.class, (Object)(horseInv = (HorseInventoryContainer)otherPlayer.field_71070_bA), (String)"field_111242_f")) != logoutHorse) continue;
                otherPlayer.func_71053_j();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        BlockPos editPos;
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        Hand hand = event.getHand();
        ItemStack heldItem = event.getItemStack();
        BlockPos pos = event.getPos();
        Direction side = event.getFace();
        if (event instanceof PlayerInteractEvent.RightClickBlock) {
            ActionResultType snowPathResult;
            SlabBlock itemSlabBlock;
            Block itemBlock;
            if (side != null && !player.func_175151_a(pos, side, heldItem)) {
                return;
            }
            BlockState state = world.func_180495_p(pos);
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof BlockItem && (itemBlock = Block.func_149634_a((Item)heldItem.func_77973_b())) instanceof SlabBlock && VerticalOnlySlabBlock.getVerticalSlabFor(itemSlabBlock = (SlabBlock)itemBlock) != null) {
                VerticalOnlySlabBlock vSlab = VerticalOnlySlabBlock.getVerticalSlabFor(itemSlabBlock);
                float reachDistance = 1000.0f;
                RayTraceResult rayTrace = player.func_213324_a((double)reachDistance, 1.0f, false);
                if (rayTrace instanceof BlockRayTraceResult) {
                    ActionResultType blockInteractResult;
                    boolean sneakUsingItem;
                    BlockRayTraceResult blockRayTrace = (BlockRayTraceResult)rayTrace;
                    boolean holdingAnyItem = true;
                    boolean bl = sneakUsingItem = player.func_226563_dT_() && holdingAnyItem && (!player.func_184614_ca().doesSneakBypassUse((IWorldReader)world, pos, player) || !player.func_184592_cb().doesSneakBypassUse((IWorldReader)world, pos, player));
                    if (!sneakUsingItem && (blockInteractResult = state.func_227031_a_(world, player, hand, blockRayTrace)).func_226246_a_()) {
                        event.setCancellationResult(blockInteractResult);
                        event.setCanceled(true);
                        return;
                    }
                    ActionResultType verticalPlaceResult = vSlab.placeVerticalOrVanilla(player, hand, heldItem, world, pos, side, blockRayTrace);
                    if (verticalPlaceResult != ActionResultType.PASS) {
                        event.setCancellationResult(verticalPlaceResult);
                        event.setCanceled(true);
                        return;
                    }
                }
            }
            if (heldItem.func_77973_b() instanceof ShovelItem && (snowPathResult = SnowPathBlock.makeSnowPath(world, pos, side, player, hand, heldItem)) != ActionResultType.PASS) {
                event.setCanceled(true);
                return;
            }
            if (!world.field_72995_K && state.func_177230_c() instanceof PlateBlock && player.func_226563_dT_() && ((PlateBlock)state.func_177230_c()).popOffOneItem(world, pos, player)) {
                event.setCanceled(true);
                return;
            }
        }
        if ((event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.LeftClickBlock || event instanceof PlayerInteractEvent.RightClickItem) && !world.field_72995_K && !(heldItem.func_77973_b() instanceof RedBookItem) && CustomWaypointStructureHandler.INSTANCE.isProtectedByWaypointStructure(world, editPos = this.getEditingPos(event, pos, side, heldItem), player)) {
            event.setCanceled(true);
            return;
        }
    }

    private BlockPos getEditingPos(PlayerInteractEvent event, BlockPos pos, Direction side, ItemStack heldItem) {
        boolean isOffsetPos = this.isOffsetPosClick(event, heldItem);
        return isOffsetPos && side != null ? pos.func_177972_a(side) : pos;
    }

    private boolean isOffsetPosClick(PlayerInteractEvent event, ItemStack heldItem) {
        if (event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.RightClickItem) {
            Item item = heldItem.func_77973_b();
            return item instanceof BlockItem || item instanceof FlintAndSteelItem || item instanceof BucketItem && ((BucketItem)item).getFluid() != Fluids.field_204541_a || item instanceof HangingEntityItem;
        }
        return false;
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        World world = event.getWorld();
        if (!world.field_72995_K) {
            List explodingPositions = explosion.func_180343_e();
            explodingPositions.removeIf(pos -> CustomWaypointStructureHandler.INSTANCE.isProtectedByWaypointStructure(world, (BlockPos)pos));
        }
    }

    @SubscribeEvent
    public void onPistonMoveCheck(PistonEvent.Pre event) {
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemFrameEntity frame;
        BlockPos frameSupportPos;
        RedBookItem redBook;
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        ItemStack heldItem = event.getItemStack();
        Hand hand = event.getHand();
        Entity target = event.getTarget();
        if (heldItem.func_77973_b() instanceof RedBookItem && target instanceof ItemFrameEntity && (redBook = (RedBookItem)heldItem.func_77973_b()).createCustomWaypointStructure(world, frameSupportPos = CustomWaypointStructureHandler.getItemFrameSupportPos(frame = (ItemFrameEntity)target), player)) {
            event.setCanceled(true);
            return;
        }
        if (!player.field_71075_bZ.field_75098_d && heldItem.func_77973_b() instanceof EmptyVesselItem && EmptyVesselItem.canMilk(target)) {
            VesselType vesselType = ((EmptyVesselItem)heldItem.func_77973_b()).getVessel();
            ItemStack milkDrink = new ItemStack((IItemProvider)LOTRItems.MILK_DRINK.get());
            VesselDrinkItem.setVessel(milkDrink, vesselType);
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            heldItem.func_190918_g(1);
            if (heldItem.func_190926_b()) {
                player.func_184611_a(hand, milkDrink);
            } else if (!player.field_71071_by.func_70441_a(milkDrink)) {
                player.func_71019_a(milkDrink, false);
            }
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            return;
        }
    }

    @SubscribeEvent
    public void onBoneMealGrow(BonemealEvent event) {
        IGrowable grassAsGrowable;
        World world = event.getWorld();
        Random rand = world.field_73012_v;
        BlockState state = event.getBlock();
        BlockPos pos = event.getPos();
        if (world.func_201675_m() instanceof LOTRDimension && state.func_177230_c() == Blocks.field_196658_i && (grassAsGrowable = (IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)world, pos, state, world.field_72995_K)) {
            if (world instanceof ServerWorld && grassAsGrowable.func_180670_a(world, world.field_73012_v, pos, state)) {
                BlockPos above = pos.func_177984_a();
                int tries = 128;
                block0: for (int i = 0; i < tries; ++i) {
                    BlockPos plantPos = above;
                    int triesHere = 0;
                    while (true) {
                        if (triesHere >= i / 16) {
                            BlockState plant;
                            BlockState curBlock = world.func_180495_p(plantPos);
                            if (curBlock.func_177230_c() instanceof TallGrassBlock && rand.nextInt(10) == 0) {
                                ((IGrowable)curBlock.func_177230_c()).func_225535_a_((ServerWorld)world, rand, plantPos, curBlock);
                            }
                            if (!curBlock.isAir((IBlockReader)world, plantPos)) continue block0;
                            Biome biome = world.func_226691_t_(plantPos);
                            if (rand.nextInt(8) == 0) {
                                List flowerList = world.func_226691_t_(plantPos).func_201853_g();
                                if (flowerList.isEmpty()) continue block0;
                                ConfiguredFeature flowerFeature = ((DecoratedFeatureConfig)((ConfiguredFeature)flowerList.get((int)0)).field_222738_b).field_214689_a;
                                plant = ((FlowersFeature)flowerFeature.field_222737_a).func_225562_b_(rand, plantPos, flowerFeature.field_222738_b);
                            } else {
                                plant = biome instanceof LOTRBiomeBase ? ((LOTRBiomeBase)biome).getGrassForBonemeal(rand, plantPos) : Blocks.field_150349_c.func_176223_P();
                            }
                            if (!plant.func_196955_c((IWorldReader)world, plantPos)) continue block0;
                            world.func_180501_a(plantPos, plant, 3);
                            continue block0;
                        }
                        if (world.func_180495_p((plantPos = plantPos.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != grassAsGrowable || world.func_180495_p(plantPos).func_224756_o((IBlockReader)world, plantPos)) continue block0;
                        ++triesHere;
                    }
                }
            }
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    @SubscribeEvent
    public void onSaplingGrow(SaplingGrowTreeEvent event) {
        IWorld world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        Random rand = event.getRand();
        if (state.func_177230_c() == Blocks.field_196676_v) {
            BirchTreeAlt altTree = new BirchTreeAlt();
            ServerWorld sWorld = (ServerWorld)world;
            altTree.func_225545_a_((IWorld)sWorld, sWorld.func_72863_F().func_201711_g(), pos, state, rand);
            event.setResult(Event.Result.DENY);
            return;
        }
    }

    @SubscribeEvent
    public void onPlayerHarvestCheck(PlayerEvent.HarvestCheck event) {
        BlockState state = event.getTargetBlock();
        PlayerEntity player = event.getPlayer();
        ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
        if (state.func_177230_c() instanceof HangingWebBlock && !heldItem.func_190926_b() && heldItem.func_150998_b(Blocks.field_196553_aF.func_176223_P())) {
            event.setCanHarvest(true);
            return;
        }
    }

    @SubscribeEvent
    public void onBreakSpeedCheck(PlayerEvent.BreakSpeed event) {
        BlockState state = event.getState();
        PlayerEntity player = event.getPlayer();
        ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
        if (state.func_177230_c() instanceof HangingWebBlock && !heldItem.func_190926_b()) {
            this.adjustRelativeSpeedToMatch(event, Blocks.field_196553_aF);
            return;
        }
        if (state.func_177230_c() instanceof FallenLeavesBlock && !heldItem.func_190926_b()) {
            this.adjustRelativeSpeedToMatch(event, ((FallenLeavesBlock)state.func_177230_c()).getBaseLeafBlock());
            return;
        }
    }

    private void adjustRelativeSpeedToMatch(PlayerEvent.BreakSpeed event, Block desiredBlockSpeed) {
        ItemStack heldItem = event.getPlayer().func_184586_b(Hand.MAIN_HAND);
        float desiredBaseSpeed = heldItem.func_150997_a(desiredBlockSpeed.func_176223_P());
        float actualBaseSpeed = heldItem.func_150997_a(event.getState());
        float relativeSpeed = desiredBaseSpeed / actualBaseSpeed;
        event.setNewSpeed(event.getOriginalSpeed() * relativeSpeed);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K && player instanceof ServerPlayerEntity && world instanceof ServerWorld) {
            ServerPlayerEntity sPlayer = (ServerPlayerEntity)player;
            ServerWorld sWorld = (ServerWorld)world;
            RespawnDataModule respawnData = LOTRLevelData.serverInstance().getData((PlayerEntity)sPlayer).getRespawnData();
            BlockPos deathPoint = respawnData.getDeathPoint();
            DimensionType dimType = respawnData.getDeathDimension();
            if (dimType == LOTRDimensions.middleEarth() && world.func_82736_K().func_223586_b(LOTRGameRules.MIDDLE_EARTH_RESPAWNING)) {
                double respawnThreshold;
                BlockPos bedLocation = sPlayer.getBedLocation(dimType);
                Optional bedSpawnPos = Optional.empty();
                if (bedLocation != null) {
                    bedSpawnPos = PlayerEntity.func_213822_a((IWorldReader)sWorld, (BlockPos)bedLocation, (boolean)sPlayer.isSpawnForced(sPlayer.field_71093_bK));
                }
                boolean hasBed = bedSpawnPos.isPresent();
                Vec3d spawnLocation = bedSpawnPos.orElseGet(() -> {
                    BlockPos worldSpawn = sWorld.func_175694_M();
                    return new Vec3d((double)worldSpawn.func_177958_n() + 0.5, (double)worldSpawn.func_177956_o() + 0.1, (double)worldSpawn.func_177952_p() + 0.5);
                });
                double d = respawnThreshold = hasBed ? 5000.0 : 2000.0;
                if (deathPoint != null) {
                    boolean outsideRange;
                    boolean bl = outsideRange = spawnLocation.func_186679_c((double)deathPoint.func_177958_n() + 0.5, (double)deathPoint.func_177956_o(), (double)deathPoint.func_177952_p() + 0.5) > respawnThreshold * respawnThreshold;
                    if (outsideRange) {
                        double randomDistance = MathHelper.func_76136_a((Random)world.field_73012_v, (int)500, (int)1500);
                        float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                        int x = deathPoint.func_177958_n() + (int)(randomDistance * (double)MathHelper.func_76126_a((float)angle));
                        int z = deathPoint.func_177952_p() + (int)(randomDistance * (double)MathHelper.func_76134_b((float)angle));
                        int y = LOTRUtil.forceLoadChunkAndGetTopBlock(world, x, z);
                        sPlayer.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, sPlayer.field_70177_z, sPlayer.field_70125_A);
                        sPlayer.field_71135_a.func_147364_a((double)x + 0.5, (double)y, (double)z + 0.5, sPlayer.field_70177_z, sPlayer.field_70125_A);
                        if (hasBed) {
                            sPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("chat.lotr.respawn.farFromBed", new Object[0]));
                        } else {
                            sPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("chat.lotr.respawn.farFromWorldSpawn", new Object[0]));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onSleepFinished(SleepFinishedTimeEvent event) {
        ServerWorld world = (ServerWorld)event.getWorld();
        if (!world.func_201670_d() && world.func_201675_m() instanceof LOTRDimension) {
            LOTRTime.advanceToMorning(world);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        SkeletonHorseEntity skeleHorse;
        Entity entity = event.getEntity();
        World world = event.getWorld();
        if (!world.field_72995_K && world.func_201675_m() instanceof LOTRDimension && entity instanceof SkeletonHorseEntity && (skeleHorse = (SkeletonHorseEntity)entity).func_190690_dh()) {
            BlockPos pos = skeleHorse.func_180425_c();
            LOTRLog.info("Cancelled the spawn of a skeleton trap horse at %d %d %d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && entity instanceof FoxEntity && world.func_201675_m() instanceof LOTRDimension) {
            FoxEntity fox = (FoxEntity)entity;
            String biomeCheckKey = String.format("%s:%s", "lotr", "FoxBiomeCheck");
            if (!fox.getPersistentData().func_74767_n(biomeCheckKey)) {
                FoxEntity.Type initialFoxType;
                FoxEntity.Type newFoxType = initialFoxType = fox.func_213471_dV();
                BlockPos entityPos = entity.func_180425_c();
                Biome biome = world.func_226691_t_(entity.func_180425_c());
                if (biome.func_225486_c(entityPos) < 0.15f) {
                    newFoxType = FoxEntity.Type.SNOW;
                }
                if (newFoxType != initialFoxType) {
                    try {
                        Method m_setVariantType = ObfuscationReflectionHelper.findMethod(FoxEntity.class, (String)"func_213474_a", (Class[])new Class[]{FoxEntity.Type.class});
                        LOTRUtil.unlockMethod(m_setVariantType);
                        m_setVariantType.invoke((Object)fox, newFoxType);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        LOTRLog.error("Error setting fox type based on biome");
                        e.printStackTrace();
                    }
                }
                fox.getPersistentData().func_74757_a(biomeCheckKey, true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        DamageSource damage = event.getSource();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            LOTRLevelData.serverInstance().getData(player).onDeath(player);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        IWorld world = event.getWorld();
        if (!world.func_201670_d() && world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            LOTRTime.save((ServerWorld)world);
        }
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        this.speechGarbler.handle(event);
    }
}

