/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lotr.common.data.LOTRLevelData;
import lotr.common.entity.item.RingPortalEntity;
import lotr.common.init.LOTRDimensions;
import lotr.common.time.LOTRDate;
import lotr.common.time.LOTRTime;
import lotr.common.world.RingPortalTeleporter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class LOTRTickHandlerServer {
    private List<Entity> ringPortalTransfers = new ArrayList<Entity>();
    private Map<Entity, Integer> ringPortalPlayerTicks = new HashMap<Entity, Integer>();
    public static final int RING_PORTAL_PLAYER_TIME = 100;

    public LOTRTickHandlerServer() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            ServerWorld world = (ServerWorld)event.world;
            TickEvent.Phase phase = event.phase;
            LOTRLevelData levelData = LOTRLevelData.serverInstance();
            if (phase == TickEvent.Phase.START && world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
                if (levelData.needsLoad()) {
                    levelData.load(world);
                }
                if (LOTRTime.needsLoad()) {
                    LOTRTime.load(world);
                }
            }
            if (phase == TickEvent.Phase.END) {
                if (world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
                    if (levelData.anyDataNeedsSave()) {
                        levelData.save(world);
                    }
                    if (world.func_82737_E() % 600L == 0L) {
                        levelData.save(world);
                        levelData.saveAndClearUnusedPlayerData(world);
                    }
                } else if (world.func_201675_m().func_186058_p() == LOTRDimensions.middleEarth()) {
                    LOTRTime.updateTime((World)world);
                    LOTRDate.updateDate(world);
                    if (world.func_82737_E() % 20L == 0L) {
                        for (PlayerEntity player : world.func_217369_A()) {
                            levelData.sendPlayerLocationsToPlayer(player, world);
                        }
                    }
                }
                HashSet<Object> removes = new HashSet<Object>();
                for (Entity e : this.ringPortalTransfers) {
                    if (!e.func_70089_S() || e.field_70170_p == null) {
                        removes.add(e);
                        continue;
                    }
                    if (e.field_70170_p != world) continue;
                    boolean inPortal = LOTRTickHandlerServer.checkInRingPortal(e);
                    if (e instanceof PlayerEntity) {
                        PlayerEntity player = (PlayerEntity)e;
                        if (inPortal) {
                            int i = this.ringPortalPlayerTicks.getOrDefault(player, 0);
                            this.ringPortalPlayerTicks.put((Entity)player, ++i);
                            if (i < 100) continue;
                            RingPortalTeleporter.transferEntity((Entity)player, true);
                            this.ringPortalPlayerTicks.remove(player);
                            removes.add(player);
                            continue;
                        }
                        this.ringPortalPlayerTicks.remove(player);
                        continue;
                    }
                    if (inPortal) {
                        RingPortalTeleporter.transferEntity(e, true);
                    }
                    removes.add(e);
                }
                this.ringPortalTransfers.removeAll(removes);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.player;
            ServerWorld world = player.func_71121_q();
            TickEvent.Phase phase = event.phase;
            if (phase == TickEvent.Phase.END) {
                LOTRLevelData.serverInstance().getData((PlayerEntity)player).onUpdate(player, world);
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        boolean isCompleteUnload;
        IWorld world = event.getWorld();
        boolean bl = isCompleteUnload = !world.func_201670_d() && world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_;
        if (isCompleteUnload) {
            this.ringPortalTransfers.clear();
            this.ringPortalPlayerTicks.clear();
        }
    }

    public void prepareRingPortal(Entity entity) {
        if (!this.ringPortalTransfers.contains(entity)) {
            this.ringPortalTransfers.add(entity);
        }
    }

    public static boolean checkInRingPortal(Entity entity) {
        if (entity instanceof RingPortalEntity || entity.func_184218_aH()) {
            return false;
        }
        double searchRange = 8.0;
        List portals = entity.field_70170_p.func_217357_a(RingPortalEntity.class, entity.func_174813_aQ().func_72321_a(searchRange, searchRange, searchRange));
        boolean inPortal = false;
        for (RingPortalEntity portal : portals) {
            if (!portal.func_174813_aQ().func_72326_a(entity.func_174813_aQ())) continue;
            return true;
        }
        return false;
    }
}

