/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.event.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import lotr.common.init.LOTRLootModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ILootGenerator;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.apache.commons.lang3.mutable.MutableInt;

public class PolarBearBlubberModifier
extends LootModifier {
    private final List<LootEntry> extraEntries;

    public PolarBearBlubberModifier(ILootCondition[] conds, LootEntry extraEntry) {
        super(conds);
        this.extraEntries = ImmutableList.of((Object)extraEntry);
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (entity instanceof PolarBearEntity) {
            Consumer stacksOut = stack -> generatedLoot.add((ItemStack)stack);
            stacksOut = LootTable.func_216124_a(stacksOut);
            Consumer consumer = ILootFunction.func_215858_a((BiFunction)LootFunctionManager.field_216242_a, (Consumer)stacksOut, (LootContext)context);
            this.generateExtraLootEntry(consumer, context);
        }
        return generatedLoot;
    }

    private void generateExtraLootEntry(Consumer<ItemStack> consumer, LootContext context) {
        Random random = context.func_216032_b();
        ArrayList lootGens = Lists.newArrayList();
        MutableInt totalWeight = new MutableInt();
        for (LootEntry lootentry : this.extraEntries) {
            lootentry.expand(context, gen -> {
                int weight = gen.func_186361_a(context.func_186491_f());
                if (weight > 0) {
                    lootGens.add(gen);
                    totalWeight.add(weight);
                }
            });
        }
        int numLootGens = lootGens.size();
        if (totalWeight.intValue() != 0 && numLootGens != 0) {
            if (numLootGens == 1) {
                ((ILootGenerator)lootGens.get(0)).func_216188_a(consumer, context);
            } else {
                int weight = random.nextInt(totalWeight.intValue());
                for (ILootGenerator ilootgenerator : lootGens) {
                    if ((weight -= ilootgenerator.func_186361_a(context.func_186491_f())) >= 0) continue;
                    ilootgenerator.func_216188_a(consumer, context);
                    return;
                }
            }
        }
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<PolarBearBlubberModifier> {
        public PolarBearBlubberModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditions) {
            LootEntry extraEntry = (LootEntry)LOTRLootModifiers.getLootTableManagerGson().fromJson(object.get("extra_entry"), LootEntry.class);
            return new PolarBearBlubberModifier(conditions, extraEntry);
        }
    }
}

