/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import lotr.common.config.LOTRConfig;
import lotr.common.data.LOTRLevelData;
import lotr.common.fac.AreaOfInfluence;
import lotr.common.fac.Faction;
import lotr.common.init.LOTRWorldTypes;
import lotr.common.world.map.MapSettings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class AreasOfInfluence {
    private final MapSettings mapSettings;
    private final Faction theFaction;
    private final boolean isolationist;
    private final List<AreaOfInfluence> areas;
    private double[] calculatedAreaBorders = null;
    public static final int DEFAULT_REDUCED_INFLUENCE_RANGE = 50;

    public AreasOfInfluence(MapSettings map, Faction theFaction, boolean isolationist, List<AreaOfInfluence> areas) {
        this.mapSettings = map;
        this.theFaction = theFaction;
        this.isolationist = isolationist;
        this.areas = areas;
    }

    public static AreasOfInfluence read(Faction theFaction, JsonObject json, MapSettings mapSettings) {
        boolean isolationist = json.get("isolationist").getAsBoolean();
        JsonArray areasArray = json.get("areas").getAsJsonArray();
        ArrayList<AreaOfInfluence> areas = new ArrayList<AreaOfInfluence>();
        for (JsonElement areaElement : areasArray) {
            AreaOfInfluence area = AreaOfInfluence.read(mapSettings, theFaction.getName(), areaElement.getAsJsonObject());
            if (area == null) continue;
            areas.add(area);
        }
        return new AreasOfInfluence(mapSettings, theFaction, isolationist, areas);
    }

    public static AreasOfInfluence read(Faction theFaction, PacketBuffer buf, MapSettings mapSettings) {
        boolean isolationist = buf.readBoolean();
        ArrayList<AreaOfInfluence> areas = new ArrayList<AreaOfInfluence>();
        int numAreasOfInfluence = buf.func_150792_a();
        for (int i = 0; i < numAreasOfInfluence; ++i) {
            AreaOfInfluence area = AreaOfInfluence.read(mapSettings, theFaction.getName(), buf);
            if (area == null) continue;
            areas.add(area);
        }
        return new AreasOfInfluence(mapSettings, theFaction, isolationist, areas);
    }

    public void write(PacketBuffer buf) {
        buf.writeBoolean(this.isolationist);
        buf.func_150787_b(this.areas.size());
        this.areas.forEach(area -> area.write(buf));
    }

    public boolean isIsolationist() {
        return this.isolationist;
    }

    public List<AreaOfInfluence> getAreas() {
        return this.areas;
    }

    public static boolean areAreasOfInfluenceEnabled(World world) {
        boolean enabledInConfig = world.field_72995_K ? LOTRLevelData.clientInstance().clientsideThisServer_areasOfInfluence : (Boolean)LOTRConfig.COMMON.areasOfInfluence.get();
        return enabledInConfig && LOTRWorldTypes.hasMapFeatures((IWorld)world);
    }

    public boolean isInArea(PlayerEntity player) {
        return this.isInArea(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
    }

    public boolean isInArea(World world, double x, double y, double z) {
        return this.isInDefinedArea(world, x, y, z);
    }

    public boolean isInDefinedArea(PlayerEntity player) {
        return this.isInDefinedArea(player, 0);
    }

    public boolean isInDefinedArea(PlayerEntity player, int extraMapRange) {
        return this.isInDefinedArea(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), extraMapRange);
    }

    public boolean isInDefinedArea(World world, double x, double y, double z) {
        return this.isInDefinedArea(world, x, y, z, 0);
    }

    public boolean isInDefinedArea(World world, double x, double y, double z, int extraMapRange) {
        if (world.func_201675_m().func_186058_p() == this.theFaction.getDimension()) {
            if (!AreasOfInfluence.areAreasOfInfluenceEnabled(world)) {
                return true;
            }
            return this.areas.stream().anyMatch(area -> area.isInArea(x, y, z, extraMapRange));
        }
        return false;
    }

    public int getReducedInfluenceRange() {
        return this.isolationist ? 0 : 50;
    }

    public float getAlignmentMultiplier(PlayerEntity player) {
        if (this.isInArea(player)) {
            return 1.0f;
        }
        int reducedRange = this.getReducedInfluenceRange();
        double dist = this.distanceToNearestAreaInRange(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), reducedRange);
        if (dist >= 0.0) {
            double mapDist = this.mapSettings.worldToMapDistance(dist);
            float frac = (float)mapDist / (float)reducedRange;
            float mplier = 1.0f - frac;
            mplier = MathHelper.func_76131_a((float)mplier, (float)0.0f, (float)1.0f);
            return mplier;
        }
        return 0.0f;
    }

    public double distanceToNearestAreaInRange(double x, double y, double z, int mapRange) {
        double closestDist = -1.0;
        int coordRange = this.mapSettings.mapToWorldDistance(mapRange);
        for (AreaOfInfluence area : this.areas) {
            double dz;
            double dx = x - area.getWorldX();
            double dSq = dx * dx + (dz = z - area.getWorldZ()) * dz;
            double dToEdge = Math.sqrt(dSq) - (double)area.getWorldRadius();
            if (!(dToEdge <= (double)coordRange) || !(closestDist < 0.0) && !(dToEdge < closestDist)) continue;
            closestDist = dToEdge;
        }
        return closestDist;
    }

    public double[] calculateAreaOfInfluenceBordersIncludingReduced() {
        if (this.calculatedAreaBorders == null) {
            double xMin = 0.0;
            double xMax = 0.0;
            double zMin = 0.0;
            double zMax = 0.0;
            boolean first = true;
            for (AreaOfInfluence area : this.areas) {
                double cxMin = area.getWorldX() - (double)area.getWorldRadius();
                double cxMax = area.getWorldX() + (double)area.getWorldRadius();
                double czMin = area.getWorldZ() - (double)area.getWorldRadius();
                double czMax = area.getWorldZ() + (double)area.getWorldRadius();
                if (first) {
                    xMin = cxMin;
                    xMax = cxMax;
                    zMin = czMin;
                    zMax = czMax;
                    first = false;
                    continue;
                }
                xMin = Math.min(xMin, cxMin);
                xMax = Math.max(xMax, cxMax);
                zMin = Math.min(zMin, czMin);
                zMax = Math.max(zMax, czMax);
            }
            int reducedWorldRange = this.mapSettings.mapToWorldDistance(this.getReducedInfluenceRange());
            this.calculatedAreaBorders = new double[]{xMin -= (double)reducedWorldRange, xMax += (double)reducedWorldRange, zMin -= (double)reducedWorldRange, zMax += (double)reducedWorldRange};
        }
        return this.calculatedAreaBorders;
    }

    public boolean sharesAreaWith(Faction other) {
        return this.sharesAreaWith(other, 0);
    }

    public boolean sharesAreaWith(Faction other, int extraMapRadius) {
        List<AreaOfInfluence> otherAreas = other.getAreasOfInfluence().getAreas();
        return this.areas.stream().anyMatch(area -> otherAreas.stream().anyMatch(otherArea -> area.intersectsWith((AreaOfInfluence)otherArea, extraMapRadius)));
    }
}

