/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import java.util.Optional;
import lotr.common.LOTRLog;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionSettings;
import lotr.common.world.fac.FactionSettingsManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldReader;

public class FactionPointer {
    private final ResourceLocation name;

    private FactionPointer(ResourceLocation name) {
        this.name = name;
    }

    public static FactionPointer of(ResourceLocation name) {
        return new FactionPointer(name);
    }

    public static FactionPointer of(String namespace, String path) {
        return FactionPointer.of(new ResourceLocation(namespace, path));
    }

    public Optional<Faction> resolveFaction(IWorldReader world) {
        FactionSettings currentSettings = FactionSettingsManager.sidedInstance(world).getCurrentLoadedFactions();
        if (currentSettings == null) {
            LOTRLog.error("Tried to call a FactionPointer (%s) outside the context of a currently loaded faction list");
            return Optional.empty();
        }
        return Optional.ofNullable(currentSettings.getFactionByName(this.name));
    }
}

