/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import com.google.gson.JsonObject;
import java.util.Comparator;
import lotr.common.LOTRLog;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionRankNameDecomposer;
import lotr.common.fac.RankGender;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class FactionRank {
    private final Faction faction;
    private final String name;
    private final float alignment;
    private final boolean isPledgeRank;

    public FactionRank(Faction faction, String name, float alignment, boolean isPledgeRank) {
        this.faction = faction;
        this.name = name;
        this.alignment = alignment;
        this.isPledgeRank = isPledgeRank;
    }

    public static FactionRank read(Faction faction, JsonObject json) {
        String name = json.get("name").getAsString();
        float alignment = json.get("alignment").getAsFloat();
        if (alignment <= 0.0f) {
            LOTRLog.warn("Faction rank %s.%s is invalid - alignment must be greater than 0", faction.getName(), name);
            return null;
        }
        boolean isPledgeRank = json.has("is_pledge_rank") && json.get("is_pledge_rank").getAsBoolean();
        return new FactionRank(faction, name, alignment, isPledgeRank);
    }

    public static FactionRank read(Faction faction, PacketBuffer buf) {
        String name = buf.func_218666_n();
        float alignment = buf.readFloat();
        if (alignment <= 0.0f) {
            LOTRLog.warn("Received invalid faction rank %s.%s from server with alignment not greater than 0", faction.getName(), name);
        }
        boolean isPledgeRank = buf.readBoolean();
        return new FactionRank(faction, name, alignment, isPledgeRank);
    }

    public void write(PacketBuffer buf) {
        buf.func_180714_a(this.name);
        buf.writeFloat(this.alignment);
        buf.writeBoolean(this.isPledgeRank);
    }

    public String getBaseName() {
        return this.name;
    }

    public String getTranslationNameKey() {
        ResourceLocation facName = this.faction.getName();
        return String.format("faction.%s.%s.rank.%s", facName.func_110624_b(), facName.func_110623_a(), this.getBaseName());
    }

    private String getTranslatedName() {
        return new TranslationTextComponent(this.getTranslationNameKey(), new Object[0]).func_150254_d();
    }

    public String getDisplayShortName(RankGender gender) {
        return FactionRankNameDecomposer.actOn(this.getTranslatedName()).getShortName(gender);
    }

    public String getDisplayFullName(RankGender gender) {
        return FactionRankNameDecomposer.actOn(this.getTranslatedName()).getFullName(gender);
    }

    public boolean isDummyRank() {
        return false;
    }

    public float getAlignment() {
        return this.alignment;
    }

    public boolean isPledgeRank() {
        return this.isPledgeRank;
    }

    public boolean isAbovePledgeRank() {
        return this.alignment > this.faction.getPledgeAlignment();
    }

    public static Comparator<FactionRank> sortAscending() {
        return (rank1, rank2) -> {
            if (rank1.faction != rank2.faction) {
                throw new IllegalArgumentException("Cannot compare two ranks from different factions!");
            }
            float align1 = rank1.alignment;
            float align2 = rank2.alignment;
            if (align1 == align2) {
                throw new IllegalArgumentException("Two ranks cannot have the same alignment value!");
            }
            return Float.compare(align1, align2);
        };
    }

    public static Comparator<FactionRank> sortDescending() {
        return FactionRank.sortAscending().reversed();
    }
}

