/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import lotr.common.fac.RankGender;

public class FactionRankNameDecomposer {
    private final String translatedName;
    private final String shortNameMasc;
    private final String shortNameFem;
    private final String fullNameMasc;
    private final String fullNameFem;

    private FactionRankNameDecomposer(String translatedName) {
        this.translatedName = translatedName;
        String[] shortAndFullNames = FactionRankNameDecomposer.decomposeIntoShortAndFull(translatedName);
        String[] mascAndFemShortNames = FactionRankNameDecomposer.decomposeIntoMascAndFem(shortAndFullNames[0]);
        String[] mascAndFemFullNames = FactionRankNameDecomposer.decomposeIntoMascAndFem(shortAndFullNames[1]);
        this.shortNameMasc = mascAndFemShortNames[0];
        this.shortNameFem = mascAndFemShortNames[1];
        this.fullNameMasc = mascAndFemFullNames[0];
        this.fullNameFem = mascAndFemFullNames[1];
    }

    public static FactionRankNameDecomposer actOn(String translatedName) {
        return new FactionRankNameDecomposer(translatedName);
    }

    private static String[] decomposeIntoShortAndFull(String name) {
        return FactionRankNameDecomposer.splitInHalfAndTrim(name, '|');
    }

    private static String[] decomposeIntoMascAndFem(String name) {
        return FactionRankNameDecomposer.splitInHalfAndTrim(name, '~');
    }

    private static String[] splitInHalfAndTrim(String name, char splitter) {
        int splitIndex = name.indexOf(splitter);
        if (splitIndex < 0) {
            return new String[]{name, name};
        }
        String first = name.substring(0, splitIndex);
        String second = name.substring(splitIndex + 1);
        return new String[]{first.trim(), second.trim()};
    }

    public String getShortName(RankGender gender) {
        return gender == RankGender.FEMININE ? this.shortNameFem : this.shortNameMasc;
    }

    public String getFullName(RankGender gender) {
        return gender == RankGender.FEMININE ? this.fullNameFem : this.fullNameMasc;
    }
}

