/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lotr.common.LOTRLog;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionPair;
import lotr.common.fac.FactionRelation;
import lotr.common.fac.FactionSettings;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class FactionRelationsTable {
    private final Map<FactionPair, FactionRelation> relations;
    private final int loadOrder;
    private final int numCombinedFrom;

    public FactionRelationsTable(Map<FactionPair, FactionRelation> relations, int loadOrder, int numCombinedFrom) {
        this.relations = relations;
        this.loadOrder = loadOrder;
        this.numCombinedFrom = numCombinedFrom;
    }

    public static FactionRelationsTable read(FactionSettings facSettings, ResourceLocation relationsTableName, JsonObject json) {
        int loadOrder = json.get("load_order").getAsInt();
        HashMap<FactionPair, FactionRelation> relations = new HashMap<FactionPair, FactionRelation>();
        JsonObject relationsJson = json.get("relations").getAsJsonObject();
        for (Map.Entry entry : relationsJson.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            try {
                List splitKey = Stream.of(key.split(",")).map(String::trim).collect(Collectors.toList());
                if (splitKey.size() == 2) {
                    String facName1 = (String)splitKey.get(0);
                    String facName2 = (String)splitKey.get(1);
                    Faction fac1 = facSettings.getFactionByName(new ResourceLocation(facName1));
                    Faction fac2 = facSettings.getFactionByName(new ResourceLocation(facName2));
                    if (fac1 == null) {
                        LOTRLog.warn("Faction relations table %s references faction %s - but no such faction exists", relationsTableName, facName1);
                        continue;
                    }
                    if (fac2 == null) {
                        LOTRLog.warn("Faction relations table %s references faction %s - but no such faction exists", relationsTableName, facName2);
                        continue;
                    }
                    if (fac1 == fac2) {
                        LOTRLog.warn("Faction relations table %s cannot declare a faction's relation to itself (%s)", relationsTableName, facName1);
                        continue;
                    }
                    FactionPair factionPair = FactionPair.of(fac1, fac2);
                    if (relations.containsKey(factionPair)) {
                        LOTRLog.warn("Faction relations table %s contains duplicate key for pair (%s, %s) - relations were already declared as %s", relationsTableName, facName1, facName2, ((FactionRelation)((Object)relations.get((Object)factionPair))).codeName);
                        continue;
                    }
                    String relationName = value.getAsString();
                    FactionRelation relation = FactionRelation.forName(relationName);
                    if (relation != null) {
                        relations.put(factionPair, relation);
                        continue;
                    }
                    LOTRLog.warn("Faction relations table %s references relation %s - but no such relation exists", relationsTableName, relationName);
                    continue;
                }
                LOTRLog.warn("Failed to parse a faction relations key in table %s: key = %s - expected two factions separated by a comma", relationsTableName, key);
            }
            catch (Exception e) {
                LOTRLog.warn("Failed to parse a faction relations line in table %s: key = %s, value = %s", relationsTableName, key, value);
                e.printStackTrace();
            }
        }
        return new FactionRelationsTable(relations, loadOrder, 0);
    }

    public static FactionRelationsTable combine(List<FactionRelationsTable> relationsTables) {
        ArrayList<FactionRelationsTable> sorted = new ArrayList<FactionRelationsTable>(relationsTables);
        Collections.sort(sorted, Comparator.comparingInt(FactionRelationsTable::getLoadOrder));
        HashMap<FactionPair, FactionRelation> relations = new HashMap<FactionPair, FactionRelation>();
        for (FactionRelationsTable table : sorted) {
            relations.putAll(table.relations);
        }
        return new FactionRelationsTable(relations, 0, sorted.size());
    }

    public static FactionRelationsTable read(FactionSettings facSettings, PacketBuffer buf) {
        HashMap<FactionPair, FactionRelation> relations = new HashMap<FactionPair, FactionRelation>();
        int numRelations = buf.func_150792_a();
        for (int i = 0; i < numRelations; ++i) {
            int facId1 = buf.func_150792_a();
            int facId2 = buf.func_150792_a();
            int relationId = buf.func_150792_a();
            Faction fac1 = facSettings.getFactionByID(facId1);
            Faction fac2 = facSettings.getFactionByID(facId2);
            FactionRelation relation = FactionRelation.forNetworkID(relationId);
            if (fac1 == null) {
                LOTRLog.warn("Received faction relation %s from server with a nonexistent faction 1 ID (%d)", facId1);
                continue;
            }
            if (fac2 == null) {
                LOTRLog.warn("Received faction relation %s from server with a nonexistent faction 2 ID (%d)", facId2);
                continue;
            }
            if (relation == null) {
                LOTRLog.warn("Received faction relation %s from server with a nonexistent relation ID (%d)", relationId);
                continue;
            }
            relations.put(FactionPair.of(fac1, fac2), relation);
        }
        int numCombinedFrom = buf.func_150792_a();
        return new FactionRelationsTable(relations, 0, numCombinedFrom);
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.relations.size());
        this.relations.forEach((factionPair, relation) -> {
            buf.func_150787_b(factionPair.getFirst().getAssignedId());
            buf.func_150787_b(factionPair.getSecond().getAssignedId());
            buf.func_150787_b(relation.networkID);
        });
        buf.func_150787_b(this.numCombinedFrom);
    }

    private int getLoadOrder() {
        return this.loadOrder;
    }

    public FactionRelation getRelation(Faction fac1, Faction fac2) {
        if (fac1 == fac2) {
            return FactionRelation.ALLY;
        }
        FactionPair key = FactionPair.of(fac1, fac2);
        if (this.relations.containsKey(key)) {
            return this.relations.get(key);
        }
        return FactionRelation.NEUTRAL;
    }

    public int size() {
        return this.relations.size();
    }

    public int getNumCombinedFrom() {
        return this.numCombinedFrom;
    }
}

