/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fac;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lotr.common.LOTRLog;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionRegion;
import lotr.common.fac.FactionRelationsTable;
import lotr.common.init.LOTRDimensions;
import lotr.common.world.map.MapSettings;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;

public class FactionSettings {
    private final List<FactionRegion> allRegions;
    private final Map<ResourceLocation, List<FactionRegion>> regionsByDimension;
    private final Map<ResourceLocation, FactionRegion> regionsByName;
    private final Map<Integer, FactionRegion> regionsById;
    private List<Faction> allFactions;
    private Map<FactionRegion, List<Faction>> factionsByRegion;
    private Map<ResourceLocation, Faction> factionsByName;
    private Map<Integer, Faction> factionsById;
    private FactionRelationsTable relations;

    public FactionSettings(List<FactionRegion> regions) {
        this.allRegions = FactionSettings.sortRegionsByOrder(regions);
        this.regionsByDimension = FactionSettings.groupRegionsByDimensionAndSortOrder(this.allRegions);
        this.regionsByName = this.allRegions.stream().collect(Collectors.toMap(FactionRegion::getName, UnaryOperator.identity()));
        this.regionsById = this.allRegions.stream().collect(Collectors.toMap(FactionRegion::getAssignedId, UnaryOperator.identity()));
    }

    private static List<FactionRegion> sortRegionsByOrder(List<FactionRegion> regions) {
        Collections.sort(regions, Comparator.comparingInt(FactionRegion::getOrdering));
        return regions;
    }

    private static Map<ResourceLocation, List<FactionRegion>> groupRegionsByDimensionAndSortOrder(List<FactionRegion> regions) {
        Map<ResourceLocation, List<FactionRegion>> map = regions.stream().collect(Collectors.groupingBy(FactionRegion::getDimensionName));
        map.values().forEach(FactionSettings::sortRegionsByOrder);
        return map;
    }

    private static List<Faction> sortFactionsByOrder(List<Faction> factions) {
        Collections.sort(factions, Comparator.comparingInt(faction -> faction.getRegion().getOrdering()).thenComparingInt(Faction::getOrdering));
        return factions;
    }

    private static Map<FactionRegion, List<Faction>> groupFactionsByRegionAndSortOrder(List<Faction> factions) {
        Map<FactionRegion, List<Faction>> unsortedMap = factions.stream().collect(Collectors.groupingBy(Faction::getRegion));
        return unsortedMap.keySet().stream().collect(Collectors.toMap(UnaryOperator.identity(), region -> FactionSettings.sortFactionsByOrder((List)unsortedMap.get(region))));
    }

    public static FactionSettings read(MapSettings mapSettings, PacketBuffer buf) {
        ArrayList<FactionRegion> regions = new ArrayList<FactionRegion>();
        int numRegions = buf.func_150792_a();
        for (int i = 0; i < numRegions; ++i) {
            try {
                FactionRegion region = FactionRegion.read(buf);
                if (region == null) continue;
                regions.add(region);
                continue;
            }
            catch (Exception e) {
                LOTRLog.warn("Error loading a faction region from server");
                e.printStackTrace();
            }
        }
        FactionSettings facSettings = new FactionSettings(regions);
        ArrayList<Faction> factions = new ArrayList<Faction>();
        int numFactions = buf.func_150792_a();
        for (int i = 0; i < numFactions; ++i) {
            try {
                Faction faction = Faction.read(facSettings, mapSettings, buf);
                if (faction == null) continue;
                factions.add(faction);
                continue;
            }
            catch (Exception e) {
                LOTRLog.warn("Error loading a faction from server");
                e.printStackTrace();
            }
        }
        facSettings.setFactions(factions);
        FactionRelationsTable relations = FactionRelationsTable.read(facSettings, buf);
        facSettings.setRelations(relations);
        return facSettings;
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.allRegions.size());
        this.allRegions.forEach(region -> region.write(buf));
        buf.func_150787_b(this.allFactions.size());
        this.allFactions.forEach(faction -> faction.write(buf));
        this.relations.write(buf);
    }

    public List<FactionRegion> getRegions() {
        return this.allRegions;
    }

    public List<FactionRegion> getRegionsForDimension(DimensionType dim) {
        return this.regionsByDimension.get(dim.getRegistryName());
    }

    public List<FactionRegion> getRegionsForDimensionOrDefault(DimensionType dim) {
        if (!this.regionsByDimension.containsKey(dim.getRegistryName())) {
            dim = LOTRDimensions.middleEarth();
        }
        return this.getRegionsForDimension(dim);
    }

    public FactionRegion getRegionByName(ResourceLocation name) {
        return this.regionsByName.get(name);
    }

    public FactionRegion getRegionByID(int id) {
        return this.regionsById.get(id);
    }

    public List<Faction> getFactions() {
        return this.allFactions;
    }

    public void setFactions(List<Faction> facs) {
        if (this.allFactions != null) {
            throw new IllegalArgumentException("Cannot set faction list - already set!");
        }
        this.allFactions = FactionSettings.sortFactionsByOrder(facs);
        this.factionsByRegion = FactionSettings.groupFactionsByRegionAndSortOrder(this.allFactions);
        this.factionsById = this.allFactions.stream().collect(Collectors.toMap(Faction::getAssignedId, UnaryOperator.identity()));
        this.factionsByName = this.allFactions.stream().collect(Collectors.toMap(Faction::getName, UnaryOperator.identity()));
    }

    public Stream<Faction> streamFactionsExcept(Faction except) {
        return this.allFactions.stream().filter(Predicate.isEqual(except).negate());
    }

    public List<Faction> getAllPlayableAlignmentFactions() {
        return this.allFactions.stream().filter(Faction::isPlayableAlignmentFaction).collect(Collectors.toList());
    }

    public List<ResourceLocation> getFactionNames() {
        return this.getAllPlayableAlignmentFactions().stream().map(Faction::getName).collect(Collectors.toList());
    }

    public List<Faction> getFactionsForRegion(FactionRegion region) {
        return this.factionsByRegion.get(region);
    }

    public Faction getFactionByID(int id) {
        return this.factionsById.get(id);
    }

    public Faction getFactionByName(ResourceLocation name) {
        return this.factionsByName.get(name);
    }

    public FactionRelationsTable getRelations() {
        return this.relations;
    }

    public void setRelations(FactionRelationsTable rels) {
        if (this.relations != null) {
            throw new IllegalArgumentException("Cannot set faction relations - already set!");
        }
        this.relations = rels;
    }
}

