/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.init;

import com.mojang.brigadier.CommandDispatcher;
import lotr.common.LOTRLog;
import lotr.common.command.AlignmentCommand;
import lotr.common.command.DateCommand;
import lotr.common.command.FastTravelClockCommand;
import lotr.common.command.LOTRTimeCommand;
import lotr.common.command.PlayerMessageCommand;
import lotr.common.command.PledgeCommand;
import lotr.common.command.WaypointCooldownCommand;
import lotr.common.command.WaypointRegionsCommand;
import lotr.common.command.WeatherCommandFixedForDimensions;
import net.minecraft.command.CommandSource;
import net.minecraft.command.impl.GameRuleCommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;

public class LOTRCommands {
    public static void registerCommands(MinecraftServer server, CommandDispatcher<CommandSource> dispatcher) {
        LOTRTimeCommand.register(dispatcher);
        WeatherCommandFixedForDimensions.register(dispatcher);
        WaypointRegionsCommand.register(dispatcher);
        WaypointCooldownCommand.register(dispatcher);
        FastTravelClockCommand.register(dispatcher);
        DateCommand.register(dispatcher);
        AlignmentCommand.register(dispatcher);
        PlayerMessageCommand.register(dispatcher);
        PledgeCommand.register(dispatcher);
        LOTRCommands.refreshGameRulesCommandForDedicatedServer(server, dispatcher);
    }

    private static void refreshGameRulesCommandForDedicatedServer(MinecraftServer server, CommandDispatcher<CommandSource> dispatcher) {
        if (server instanceof DedicatedServer) {
            dispatcher.getRoot().getChildren().removeIf(node -> node.getName().equals("gamerule"));
            GameRuleCommand.func_198487_a(dispatcher);
            LOTRLog.info("Re-registered gamerule command to ensure mod gamerules are listed");
        }
    }
}

