/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.init;

import lotr.common.dim.LOTRDimension;
import lotr.common.dim.MiddleEarthModDimension;
import lotr.common.world.gen.MiddleEarthChunkGenerator;
import lotr.common.world.gen.MiddleEarthGenSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LOTRDimensions {
    private static final ResourceLocation MIDDLE_EARTH_ID = new ResourceLocation("lotr", "middle_earth");
    private static final ModDimension MIDDLE_EARTH_MODDIM = (ModDimension)new MiddleEarthModDimension().setRegistryName(MIDDLE_EARTH_ID);
    public static final DeferredRegister<ChunkGeneratorType<?, ?>> GENERATOR_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CHUNK_GENERATOR_TYPES, (String)"lotr");
    public static final DeferredRegister<BiomeProviderType<?, ?>> BIOME_PROVIDER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOME_PROVIDER_TYPES, (String)"lotr");
    public static final RegistryObject<ChunkGeneratorType<MiddleEarthGenSettings, MiddleEarthChunkGenerator>> MIDDLE_EARTH_GENERATOR = GENERATOR_TYPES.register("middle_earth", () -> new ChunkGeneratorType(MiddleEarthChunkGenerator::new, true, MiddleEarthGenSettings::new));

    public static void register() {
        IEventBus fmlBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        GENERATOR_TYPES.register(fmlBus);
        BIOME_PROVIDER_TYPES.register(fmlBus);
        fmlBus.register((Object)new SetupEvents());
        forgeBus.register((Object)new SetupEvents());
    }

    public static DimensionType middleEarth() {
        return DimensionManager.registerOrGetDimension((ResourceLocation)MIDDLE_EARTH_ID, (ModDimension)MIDDLE_EARTH_MODDIM, null, (boolean)true);
    }

    public static DimensionType getCurrentLOTRDimensionOrFallback(World world) {
        Dimension dimension = world.func_201675_m();
        if (dimension instanceof LOTRDimension) {
            return dimension.func_186058_p();
        }
        return LOTRDimensions.middleEarth();
    }

    public static ITextComponent getDisplayName(DimensionType dimension) {
        ResourceLocation dimensionName = dimension.getRegistryName();
        String key = String.format("dimension.%s.%s", dimensionName.func_110624_b(), dimensionName.func_110623_a());
        return new TranslationTextComponent(key, new Object[0]);
    }

    public static class SetupEvents {
        @SubscribeEvent
        public void onRegistry(RegistryEvent.Register<ModDimension> event) {
            if (event.getRegistry() == ForgeRegistries.MOD_DIMENSIONS) {
                event.getRegistry().register((IForgeRegistryEntry)MIDDLE_EARTH_MODDIM);
            }
        }

        @SubscribeEvent
        public void onDimensionRegister(RegisterDimensionsEvent event) {
            if (LOTRDimensions.middleEarth() == null) {
                LOTRDimensions.middleEarth();
            }
        }
    }
}

