/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.init;

import java.util.function.Consumer;
import lotr.common.entity.VanillaEntitySpawnChanges;
import lotr.common.entity.item.FallingTreasureBlockEntity;
import lotr.common.entity.item.LOTRBoatEntity;
import lotr.common.entity.item.RingPortalEntity;
import lotr.common.entity.projectile.ThrownPlateEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class LOTREntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"lotr");
    public static final RegistryObject<EntityType<RingPortalEntity>> RING_PORTAL = LOTREntities.regEntity("ring_portal", RingPortalEntity::new, EntityClassification.MISC, 3.0f, 1.5f);
    public static final RegistryObject<EntityType<ThrownPlateEntity>> THROWN_PLATE = LOTREntities.regEntity("thrown_plate", ThrownPlateEntity::new, EntityClassification.MISC, 0.5f, 0.5f, 4, 10);
    public static final RegistryObject<EntityType<LOTRBoatEntity>> BOAT = LOTREntities.regEntity("boat", LOTRBoatEntity::new, EntityClassification.MISC, 1.375f, 0.5625f);
    public static final RegistryObject<EntityType<FallingTreasureBlockEntity>> FALLING_TREASURE_BLOCK = LOTREntities.regEntity("falling_treasure_block", FallingTreasureBlockEntity::new, EntityClassification.MISC, 0.98f, 0.98f, 10, 20);

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ENTITIES.register(bus);
        bus.addListener(VanillaEntitySpawnChanges::makeChanges);
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> regEntity(String key, EntityType.IFactory<T> factory, EntityClassification classif, float width, float height, Consumer<EntityType.Builder<T>> extraProps) {
        return ENTITIES.register(key, () -> {
            EntityType.Builder builder = EntityType.Builder.func_220322_a((EntityType.IFactory)factory, (EntityClassification)classif).func_220321_a(width, height);
            extraProps.accept(builder);
            return builder.func_206830_a(new ResourceLocation("lotr", key).toString());
        });
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> regEntity(String key, EntityType.IFactory<T> factory, EntityClassification classif, float width, float height) {
        return LOTREntities.regEntity(key, factory, classif, width, height, builder -> {});
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> regEntity(String key, EntityType.IFactory<T> factory, EntityClassification classif, float width, float height, int trackRange, int updateFreq) {
        return LOTREntities.regEntity(key, factory, classif, width, height, builder -> {
            builder.setTrackingRange(trackRange);
            builder.setUpdateInterval(updateFreq);
        });
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> regEntity(String key, EntityType.IFactory<T> factory, EntityClassification classif, float width, float height, int trackRange, int updateFreq, boolean velUpdates) {
        return LOTREntities.regEntity(key, factory, classif, width, height, builder -> {
            builder.setTrackingRange(trackRange);
            builder.setUpdateInterval(updateFreq);
            builder.setShouldReceiveVelocityUpdates(velUpdates);
        });
    }
}

