/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.init;

import com.google.gson.Gson;
import java.lang.reflect.Field;
import lotr.common.LOTRLog;
import lotr.common.event.loot.PolarBearBlubberModifier;
import lotr.common.event.loot.RemoveApplesFromOakLeavesModifier;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class LOTRLootModifiers {
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> LOOT_MODIFIERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)"lotr");
    public static final RegistryObject<GlobalLootModifierSerializer<PolarBearBlubberModifier>> POLAR_BEAR_BLUBBER = LOOT_MODIFIERS.register("polar_bear_blubber", () -> new PolarBearBlubberModifier.Serializer());
    public static final RegistryObject<GlobalLootModifierSerializer<RemoveApplesFromOakLeavesModifier>> REMOVE_APPLES_FROM_OAK_LEAVES = LOOT_MODIFIERS.register("remove_apples_from_oak_leaves", () -> new RemoveApplesFromOakLeavesModifier.Serializer());
    private static Gson lootTableManagerGson;

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        LOOT_MODIFIERS.register(bus);
    }

    public static final Gson getLootTableManagerGson() {
        if (lootTableManagerGson == null) {
            try {
                for (Field f : LootTableManager.class.getDeclaredFields()) {
                    if (f.getType() != Gson.class) continue;
                    f.setAccessible(true);
                    lootTableManagerGson = (Gson)f.get(null);
                    break;
                }
            }
            catch (IllegalAccessException e) {
                LOTRLog.error("Failed to retrieve LootTableManager GSON instance");
                e.printStackTrace();
            }
        }
        return lootTableManagerGson;
    }
}

