/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.init;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.init.LOTRBlocks;
import lotr.common.tileentity.AlloyForgeTileEntity;
import lotr.common.tileentity.CustomWaypointMarkerTileEntity;
import lotr.common.tileentity.DwarvenForgeTileEntity;
import lotr.common.tileentity.ElvenForgeTileEntity;
import lotr.common.tileentity.GondorBeaconTileEntity;
import lotr.common.tileentity.HobbitOvenTileEntity;
import lotr.common.tileentity.KegTileEntity;
import lotr.common.tileentity.OrcForgeTileEntity;
import lotr.common.tileentity.PlateTileEntity;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class LOTRTileEntities {
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"lotr");
    public static final RegistryObject<TileEntityType<AlloyForgeTileEntity>> ALLOY_FORGE = LOTRTileEntities.register("alloy_forge", () -> TileEntityType.Builder.func_223042_a(AlloyForgeTileEntity::new, (Block[])new Block[]{(Block)LOTRBlocks.ALLOY_FORGE.get()}));
    public static final RegistryObject<TileEntityType<DwarvenForgeTileEntity>> DWARVEN_FORGE = LOTRTileEntities.register("dwarven_forge", () -> TileEntityType.Builder.func_223042_a(DwarvenForgeTileEntity::new, (Block[])new Block[]{(Block)LOTRBlocks.DWARVEN_FORGE.get()}));
    public static final RegistryObject<TileEntityType<ElvenForgeTileEntity>> ELVEN_FORGE = LOTRTileEntities.register("elven_forge", () -> TileEntityType.Builder.func_223042_a(ElvenForgeTileEntity::new, (Block[])new Block[]{(Block)LOTRBlocks.ELVEN_FORGE.get()}));
    public static final RegistryObject<TileEntityType<OrcForgeTileEntity>> ORC_FORGE = LOTRTileEntities.register("orc_forge", () -> TileEntityType.Builder.func_223042_a(OrcForgeTileEntity::new, (Block[])new Block[]{(Block)LOTRBlocks.ORC_FORGE.get()}));
    public static final RegistryObject<TileEntityType<HobbitOvenTileEntity>> HOBBIT_OVEN = LOTRTileEntities.register("hobbit_oven", () -> TileEntityType.Builder.func_223042_a(HobbitOvenTileEntity::new, (Block[])new Block[]{(Block)LOTRBlocks.HOBBIT_OVEN.get()}));
    public static final RegistryObject<TileEntityType<PlateTileEntity>> PLATE = LOTRTileEntities.register("plate", () -> TileEntityType.Builder.func_223042_a(PlateTileEntity::new, (Block[])new Block[]{(Block)LOTRBlocks.FINE_PLATE.get(), (Block)LOTRBlocks.STONEWARE_PLATE.get(), (Block)LOTRBlocks.WOODEN_PLATE.get()}));
    public static final RegistryObject<TileEntityType<KegTileEntity>> KEG = LOTRTileEntities.register("keg", () -> TileEntityType.Builder.func_223042_a(KegTileEntity::new, (Block[])new Block[]{(Block)LOTRBlocks.KEG.get()}));
    public static final RegistryObject<TileEntityType<CustomWaypointMarkerTileEntity>> CUSTOM_WAYPOINT_MARKER = LOTRTileEntities.register("custom_waypoint_marker", () -> TileEntityType.Builder.func_223042_a(CustomWaypointMarkerTileEntity::new, (Block[])new Block[]{(Block)LOTRBlocks.CUSTOM_WAYPOINT_MARKER.get()}));
    public static final RegistryObject<TileEntityType<GondorBeaconTileEntity>> GONDOR_BEACON = LOTRTileEntities.register("gondor_beacon", () -> TileEntityType.Builder.func_223042_a(GondorBeaconTileEntity::new, (Block[])new Block[]{(Block)LOTRBlocks.GONDOR_BEACON.get()}));

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        TILE_ENTITIES.register(bus);
    }

    private static <T extends TileEntity> RegistryObject<TileEntityType<T>> register(String key, Supplier<TileEntityType.Builder<T>> builderSup) {
        Type datafixType;
        block2: {
            datafixType = null;
            try {
                datafixType = DataFixesManager.func_210901_a().getSchema(DataFixUtils.makeKey((int)SharedConstants.func_215069_a().getWorldVersion())).getChoiceType(TypeReferences.field_211294_j, key);
            }
            catch (IllegalArgumentException e) {
                LOTRLog.error("No data fixer registered for block entity {}", key);
                if (!SharedConstants.field_206244_b) break block2;
                throw e;
            }
        }
        Type datafixTypeParam = datafixType;
        return TILE_ENTITIES.register(key, () -> ((TileEntityType.Builder)builderSup.get()).func_206865_a(datafixTypeParam));
    }
}

