/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.inv;

import java.util.Optional;
import lotr.common.LOTRLog;
import lotr.common.inv.FactionCraftingContainer;
import lotr.common.util.UsernameHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;

public class FactionCraftingResultSlot
extends CraftingResultSlot {
    private final PlayerEntity slotPlayer;
    private final CraftingInventory craftMatrix;
    private final FactionCraftingContainer tableContainer;

    public FactionCraftingResultSlot(PlayerEntity player, FactionCraftingContainer table, CraftingInventory tableInv, IInventory resultInv, int slot, int x, int y) {
        super(player, tableInv, resultInv, slot, x, y);
        this.slotPlayer = player;
        this.craftMatrix = tableInv;
        this.tableContainer = table;
    }

    public ItemStack func_190901_a(PlayerEntity paramPlayer, ItemStack stack) {
        this.func_75208_c(stack);
        ForgeHooks.setCraftingPlayer((PlayerEntity)paramPlayer);
        IRecipeType recipeType = this.determineRecipeType();
        NonNullList nonnulllist = paramPlayer.field_70170_p.func_199532_z().func_215369_c(recipeType, (IInventory)this.craftMatrix, paramPlayer.field_70170_p);
        ForgeHooks.setCraftingPlayer(null);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack inMatrix = this.craftMatrix.func_70301_a(i);
            ItemStack inList = (ItemStack)nonnulllist.get(i);
            if (!inMatrix.func_190926_b()) {
                this.craftMatrix.func_70298_a(i, 1);
                inMatrix = this.craftMatrix.func_70301_a(i);
            }
            if (inList.func_190926_b()) continue;
            if (inMatrix.func_190926_b()) {
                this.craftMatrix.func_70299_a(i, inList);
                continue;
            }
            if (ItemStack.func_179545_c((ItemStack)inMatrix, (ItemStack)inList) && ItemStack.func_77970_a((ItemStack)inMatrix, (ItemStack)inList)) {
                inList.func_190917_f(inMatrix.func_190916_E());
                this.craftMatrix.func_70299_a(i, inList);
                continue;
            }
            if (this.slotPlayer.field_71071_by.func_70441_a(inList)) continue;
            this.slotPlayer.func_71019_a(inList, false);
        }
        return stack;
    }

    private IRecipeType determineRecipeType() {
        Optional<ICraftingRecipe> optRecipe = this.tableContainer.findMatchingRecipeOfAppropriateType(this.slotPlayer.field_70170_p, this.slotPlayer, this.craftMatrix);
        if (optRecipe.isPresent()) {
            return optRecipe.get().func_222127_g();
        }
        LOTRLog.error("Faction crafting table (%s) failed to determine the type of the crafted recipe (crafter = %s)", this.tableContainer.func_216957_a().getRegistryName(), UsernameHelper.getRawUsername(this.slotPlayer));
        return IRecipeType.field_222149_a;
    }
}

