/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.inv;

import lotr.common.init.LOTRContainers;
import lotr.common.inv.KegResultSlot;
import lotr.common.inv.KegSlot;
import lotr.common.item.VesselDrinkItem;
import lotr.common.recipe.DrinkBrewingRecipe;
import lotr.common.tileentity.KegTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class KegContainer
extends Container {
    public final IInventory theKeg;
    private final IIntArray kegData;
    private final Slot brewResultSlot;

    public KegContainer(int id, PlayerInventory playerInv, PacketBuffer extraData) {
        this(id, playerInv, (IInventory)new Inventory(10), (IIntArray)new IntArray(3));
    }

    public KegContainer(int id, PlayerInventory playerInv, IInventory keg, IIntArray data) {
        super((ContainerType)LOTRContainers.KEG.get(), id);
        int x;
        int y;
        KegContainer.func_216962_a((IInventory)keg, (int)10);
        KegContainer.func_216959_a((IIntArray)data, (int)3);
        this.theKeg = keg;
        this.kegData = data;
        this.theKeg.func_174889_b(playerInv.field_70458_d);
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                KegSlot slot = new KegSlot(this, keg, x + y * 3, 14 + x * 18, 34 + y * 18);
                if (y == 2) {
                    slot.setWaterSource();
                }
                this.func_75146_a(slot);
            }
        }
        this.brewResultSlot = new KegResultSlot(keg, 9, 108, 52);
        this.func_75146_a(this.brewResultSlot);
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, 25 + x * 18, 139 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.func_75146_a(new Slot((IInventory)playerInv, x2, 25 + x2 * 18, 197));
        }
        this.func_216961_a(data);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.theKeg.func_70300_a(player);
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.theKeg.func_174886_c(player);
    }

    public void handleBrewButtonPress(ServerPlayerEntity player) {
        if (this.theKeg instanceof KegTileEntity && player instanceof ServerPlayerEntity) {
            ((KegTileEntity)this.theKeg).handleBrewButtonPress((PlayerEntity)player);
        }
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 9) {
                if (!this.func_75135_a(itemstack1, 10, 46, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index != 9) {
                boolean flag = false;
                Slot aKegSlot = (Slot)this.field_75151_b.get(0);
                if (aKegSlot.func_75214_a(itemstack1)) {
                    flag = DrinkBrewingRecipe.isWaterSource(itemstack1) ? this.func_75135_a(itemstack1, 6, 9, false) : this.func_75135_a(itemstack1, 0, 6, false);
                }
                if (!flag && (index >= 10 && index < 37 ? !this.func_75135_a(itemstack1, 37, 46, false) : !this.func_75135_a(itemstack1, 10, 37, false))) {
                    return null;
                }
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    public KegTileEntity.KegMode getKegMode() {
        return KegTileEntity.KegMode.forId(this.kegData.func_221476_a(0));
    }

    public boolean hasBrewingResult() {
        return this.brewResultSlot.func_75216_d();
    }

    public ItemStack getBrewingResult() {
        return this.brewResultSlot.func_75211_c();
    }

    public boolean canFinishBrewingNow() {
        ItemStack stack = this.brewResultSlot.func_75211_c();
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            if (item instanceof VesselDrinkItem) {
                return !VesselDrinkItem.getPotency(stack).isMin();
            }
            return true;
        }
        return false;
    }

    public ITextComponent getKegSubtitle() {
        ItemStack brewingItem = this.brewResultSlot.func_75211_c();
        KegTileEntity.KegMode mode = this.getKegMode();
        if (mode == KegTileEntity.KegMode.EMPTY) {
            return new TranslationTextComponent("container.lotr.keg.empty", new Object[0]);
        }
        if (mode == KegTileEntity.KegMode.BREWING && !brewingItem.func_190926_b()) {
            return new TranslationTextComponent("container.lotr.keg.brewing", new Object[]{brewingItem.func_200301_q(), VesselDrinkItem.getPotency(brewingItem).getDisplayName()});
        }
        if (mode == KegTileEntity.KegMode.FULL && !brewingItem.func_190926_b()) {
            return new TranslationTextComponent("container.lotr.keg.full", new Object[]{brewingItem.func_200301_q(), VesselDrinkItem.getPotency(brewingItem).getDisplayName(), brewingItem.func_190916_E()});
        }
        return new StringTextComponent("");
    }

    public int getBrewProgressScaled(int i) {
        int fullTime = this.kegData.func_221476_a(2);
        if (fullTime == 0) {
            return 0;
        }
        return this.kegData.func_221476_a(1) * i / fullTime;
    }

    public int getBarrelFullAmountScaled(int i) {
        return this.brewResultSlot.func_75211_c().func_190916_E() * i / 16;
    }
}

