/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import lotr.common.init.LOTRItemGroups;
import lotr.common.init.LOTRItems;
import lotr.common.init.LOTRSoundEvents;
import lotr.common.item.VesselDrinkItem;
import lotr.common.item.VesselType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EmptyVesselItem
extends Item {
    private final VesselType vesselType;

    public EmptyVesselItem(VesselType ves) {
        super(new Item.Properties().func_200916_a(LOTRItemGroups.FOOD));
        this.vesselType = ves;
    }

    public VesselType getVessel() {
        return this.vesselType;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        RayTraceResult target = EmptyVesselItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (target.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)heldItem);
        }
        if (target.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockRayTraceResult)target).func_216350_a();
            if (!world.func_175660_a(player, blockpos)) {
                return ActionResult.func_226250_c_((Object)heldItem);
            }
            if (world.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a)) {
                world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), LOTRSoundEvents.MUG_FILL, SoundCategory.NEUTRAL, 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
                return ActionResult.func_226248_a_((Object)this.createWaterVessel(heldItem, player));
            }
        }
        return ActionResult.func_226250_c_((Object)heldItem);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        ItemStack heldItem = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos = context.func_195995_a());
        if (state.func_177230_c() == Blocks.field_150383_bp) {
            int level = (Integer)state.func_177229_b((IProperty)CauldronBlock.field_176591_a);
            if (level > 0 && !world.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemStack waterDrink = new ItemStack((IItemProvider)LOTRItems.WATER_DRINK.get());
                    VesselDrinkItem.setVessel(waterDrink, this.vesselType);
                    player.func_195066_a(Stats.field_188078_L);
                    heldItem.func_190918_g(1);
                    if (heldItem.func_190926_b()) {
                        player.func_184611_a(context.func_221531_n(), waterDrink);
                    } else if (!player.field_71071_by.func_70441_a(waterDrink)) {
                        player.func_71019_a(waterDrink, false);
                    } else if (player instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
                    }
                }
                world.func_184133_a(null, pos, LOTRSoundEvents.MUG_FILL, SoundCategory.BLOCKS, 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
                ((CauldronBlock)state.func_177230_c()).func_176590_a(world, pos, state, level - 1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected ItemStack createWaterVessel(ItemStack heldItem, PlayerEntity player) {
        ItemStack waterDrink = new ItemStack((IItemProvider)LOTRItems.WATER_DRINK.get());
        VesselDrinkItem.setVessel(waterDrink, this.vesselType);
        heldItem.func_190918_g(1);
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        if (heldItem.func_190926_b()) {
            return waterDrink;
        }
        if (!player.field_71071_by.func_70441_a(waterDrink)) {
            player.func_71019_a(waterDrink, false);
        }
        return heldItem;
    }

    public static boolean canMilk(Entity target) {
        return target instanceof CowEntity && !((CowEntity)target).func_70631_g_();
    }
}

