/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.MiscDataModule;
import lotr.common.init.LOTRItemGroups;
import lotr.common.item.VesselType;
import lotr.common.util.CalendarUtil;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VesselDrinkItem
extends Item {
    private final float drinkAlcoholicity;
    private final int drinkFoodRestore;
    private final float drinkSaturation;
    public final boolean hasPotencies;
    private final float drinkDamage;
    private final List<EffectInstance> drinkEffects;

    protected VesselDrinkItem(float alc, int food, float sat, boolean hasPots, float dmg, List<EffectInstance> effs) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(LOTRItemGroups.FOOD));
        this.drinkAlcoholicity = alc;
        this.drinkFoodRestore = food;
        this.drinkSaturation = sat;
        this.hasPotencies = hasPots;
        this.drinkDamage = dmg;
        this.drinkEffects = effs;
    }

    public static VesselDrinkItem newAlcohol(float alc, int food, float sat) {
        return new VesselDrinkItem(alc, food, sat, true, 0.0f, (List<EffectInstance>)ImmutableList.of());
    }

    public static VesselDrinkItem newBasic(int food, float sat) {
        return new VesselDrinkItem(0.0f, food, sat, false, 0.0f, (List<EffectInstance>)ImmutableList.of());
    }

    public static VesselDrinkItem newEffects(int food, float sat, EffectInstance ... effs) {
        return new VesselDrinkItem(0.0f, food, sat, true, 0.0f, Arrays.asList(effs));
    }

    public static VesselDrinkItem newEffectsDamage(int food, float sat, float dmg, EffectInstance ... effs) {
        return new VesselDrinkItem(0.0f, food, sat, true, dmg, Arrays.asList(effs));
    }

    public static VesselDrinkItem newEffectsAlcohol(float alc, int food, float sat, EffectInstance ... effs) {
        return new VesselDrinkItem(alc, food, sat, true, 0.0f, Arrays.asList(effs));
    }

    public static Potency getPotency(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("vessel");
        if (nbt != null && nbt.func_150297_b("potency", 8)) {
            return Potency.forName(nbt.func_74779_i("potency"));
        }
        return Potency.MODERATE;
    }

    public static void setPotency(ItemStack stack, Potency pot) {
        stack.func_190925_c("vessel").func_74778_a("potency", pot.getCodeName());
    }

    public static VesselType getVessel(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("vessel");
        if (nbt != null && nbt.func_150297_b("type", 8)) {
            return VesselType.forName(nbt.func_74779_i("type"));
        }
        return VesselType.WOODEN_MUG;
    }

    public static void setVessel(ItemStack stack, VesselType ves) {
        stack.func_190925_c("vessel").func_74778_a("type", ves.getCodeName());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.canBeginDrinking(player, heldItem)) {
            player.func_184598_c(hand);
            return ActionResult.func_226249_b_((Object)heldItem);
        }
        return ActionResult.func_226251_d_((Object)heldItem);
    }

    protected boolean canBeginDrinking(PlayerEntity player, ItemStack stack) {
        boolean alwaysDrinkable = this.drinkAlcoholicity > 0.0f || !this.drinkEffects.isEmpty();
        return player.func_71043_e(alwaysDrinkable);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        PlayerEntity asPlayer;
        PlayerEntity playerEntity = asPlayer = entity instanceof PlayerEntity ? (PlayerEntity)entity : null;
        if (asPlayer instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)asPlayer, stack);
        }
        VesselType vessel = VesselDrinkItem.getVessel(stack);
        ItemStack emptyVessel = vessel.createEmpty();
        int heal = this.drinkFoodRestore;
        float sat = this.drinkSaturation;
        if (this.hasPotencies) {
            Potency potency = VesselDrinkItem.getPotency(stack);
            heal = Math.round((float)heal * potency.foodMultiplier);
            sat *= potency.foodMultiplier;
        }
        if (asPlayer != null) {
            asPlayer.func_71024_bL().func_75122_a(heal, sat);
            asPlayer.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            if (!asPlayer.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        } else {
            entity.func_70691_i((float)heal);
        }
        if (!world.field_72995_K && this.drinkAlcoholicity > 0.0f) {
            int duration;
            float alcStrength = this.drinkAlcoholicity * VesselDrinkItem.getPotency((ItemStack)stack).alcMultiplier;
            Optional<MiscDataModule> playerMiscData = Optional.ofNullable(asPlayer).map(p -> LOTRLevelData.sidedInstance((IWorldReader)world).getData((PlayerEntity)p).getMiscData());
            int tolerance = playerMiscData.map(MiscDataModule::getAlcoholTolerance).orElse(0);
            if (tolerance > 0) {
                float f = (float)Math.pow(0.99, tolerance);
                alcStrength *= f;
            }
            if (world.field_73012_v.nextFloat() < alcStrength && (duration = (int)(60.0f * (1.0f + world.field_73012_v.nextFloat() * 0.5f) * alcStrength)) >= 1) {
                int durationTicks = duration * 20;
                entity.func_195064_c(new EffectInstance(Effects.field_76431_k, durationTicks));
                int toleranceAdd = Math.round((float)duration / 20.0f);
                int newTolerance = tolerance + toleranceAdd;
                playerMiscData.ifPresent(miscData -> miscData.setAlcoholTolerance(newTolerance));
            }
        }
        if (!world.field_72995_K && !this.drinkEffects.isEmpty()) {
            List<EffectInstance> effects = this.convertPotionEffectsForStrength(stack);
            for (EffectInstance effect : effects) {
                if (effect.func_188419_a().func_76403_b()) {
                    effect.func_188419_a().func_180793_a((Entity)asPlayer, (Entity)asPlayer, entity, effect.func_76458_c(), 1.0);
                    continue;
                }
                entity.func_195064_c(new EffectInstance(effect));
            }
        }
        if (this.drinkDamage > 0.0f) {
            float dmg = this.drinkDamage;
            if (this.hasPotencies) {
                dmg *= VesselDrinkItem.getPotency((ItemStack)stack).alcMultiplier;
            }
            entity.func_70097_a(DamageSource.field_76376_m, dmg);
        }
        if (asPlayer == null || !asPlayer.field_71075_bZ.field_75098_d) {
            if (stack.func_190926_b()) {
                return emptyVessel;
            }
            if (asPlayer != null) {
                asPlayer.field_71071_by.func_70441_a(emptyVessel);
            }
        }
        return stack;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    private List<EffectInstance> convertPotionEffectsForStrength(ItemStack stack) {
        float strength = 1.0f;
        if (this.hasPotencies) {
            strength = VesselDrinkItem.getPotency((ItemStack)stack).alcMultiplier;
        }
        ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
        for (EffectInstance base : this.drinkEffects) {
            int duration = (int)((float)base.func_76459_b() * strength);
            EffectInstance modified = new EffectInstance(base.func_188419_a(), duration, base.func_76458_c(), base.func_82720_e(), base.func_188418_e());
            effects.add(modified);
        }
        return effects;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (CalendarUtil.isAprilFools()) {
            return new StringTextComponent("Hooch");
        }
        return super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (this.hasPotencies) {
            Potency potency = VesselDrinkItem.getPotency(stack);
            ITextComponent displayPotecy = potency.getDisplayName();
            displayPotecy.func_150256_b().func_150238_a(TextFormatting.GRAY);
            tooltip.add(displayPotecy);
            if (this.drinkAlcoholicity > 0.0f) {
                float alc = this.drinkAlcoholicity * potency.alcMultiplier * 10.0f;
                TextFormatting color = TextFormatting.GREEN;
                color = alc < 2.0f ? TextFormatting.GREEN : (alc < 5.0f ? TextFormatting.YELLOW : (alc < 10.0f ? TextFormatting.GOLD : (alc < 20.0f ? TextFormatting.RED : TextFormatting.DARK_RED)));
                TranslationTextComponent displayAlc = new TranslationTextComponent("item.lotr.drink.alcoholicity", new Object[]{Float.valueOf(alc)});
                displayAlc.func_150256_b().func_150238_a(color);
                tooltip.add((ITextComponent)displayAlc);
            }
        }
        if (this.drinkDamage > 0.0f) {
            float dmg = this.drinkDamage;
            if (this.hasPotencies) {
                dmg *= VesselDrinkItem.getPotency((ItemStack)stack).alcMultiplier;
            }
            TranslationTextComponent displayDmg = new TranslationTextComponent("item.lotr.drink.damage", new Object[]{Float.valueOf(dmg)});
            displayDmg.func_150256_b().func_150238_a(TextFormatting.RED);
            tooltip.add((ITextComponent)displayDmg);
        }
        this.addPreEffectsTooltip(stack, world, tooltip, flag);
        VesselDrinkItem.addPotionEffectsToTooltip(stack, tooltip, flag, this.convertPotionEffectsForStrength(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addPreEffectsTooltip(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
    }

    public static void addPotionEffectsToTooltip(ItemStack stack, List<ITextComponent> tooltip, ITooltipFlag flag, List<EffectInstance> itemEffects) {
        if (!itemEffects.isEmpty()) {
            ItemStack potionEquivalent = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185184_a((ItemStack)potionEquivalent, itemEffects);
            ArrayList effectTooltips = new ArrayList();
            PotionUtils.func_185182_a((ItemStack)potionEquivalent, effectTooltips, (float)1.0f);
            tooltip.addAll(effectTooltips);
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            VesselType[] displayVessels = new VesselType[]{VesselType.WOODEN_MUG};
            if (group == null || group.hasSearchBar()) {
                displayVessels = VesselType.values();
            }
            for (VesselType ves : displayVessels) {
                if (this.hasPotencies) {
                    for (Potency pot : Potency.values()) {
                        ItemStack stack = new ItemStack((IItemProvider)this);
                        VesselDrinkItem.setPotency(stack, pot);
                        VesselDrinkItem.setVessel(stack, ves);
                        items.add((Object)stack);
                    }
                    continue;
                }
                ItemStack stack = new ItemStack((IItemProvider)this);
                VesselDrinkItem.setVessel(stack, ves);
                items.add((Object)stack);
            }
        }
    }

    public static enum Potency {
        WEAK(0, "weak", 0.25f, 0.5f),
        LIGHT(1, "light", 0.5f, 0.75f),
        MODERATE(2, "moderate", 1.0f, 1.0f),
        STRONG(3, "strong", 2.0f, 1.25f),
        POTENT(4, "potent", 3.0f, 1.5f);

        public final int level;
        private static int minLevel;
        private static int maxLevel;
        public final String name;
        public final float alcMultiplier;
        public final float foodMultiplier;

        private Potency(int i, String s, float alc, float food) {
            this.level = i;
            this.name = s;
            this.alcMultiplier = alc;
            this.foodMultiplier = food;
            this.recache();
        }

        private void recache() {
            minLevel = Math.min(minLevel, this.level);
            maxLevel = Math.max(maxLevel, this.level);
        }

        public boolean isMax() {
            return this.level == maxLevel;
        }

        public boolean isMin() {
            return this.level == minLevel;
        }

        public Potency getNext() {
            if (this.isMax()) {
                return this;
            }
            return Potency.forLevel(this.level + 1);
        }

        public Potency getPrev() {
            if (this.isMin()) {
                return this;
            }
            return Potency.forLevel(this.level - 1);
        }

        public String getCodeName() {
            return this.name;
        }

        public ITextComponent getDisplayName() {
            return new TranslationTextComponent("item.lotr.drink." + this.name, new Object[0]);
        }

        public static Potency forLevel(int level) {
            for (Potency pot : Potency.values()) {
                if (pot.level != level) continue;
                return pot;
            }
            return MODERATE;
        }

        public static Potency forName(String name) {
            for (Potency pot : Potency.values()) {
                if (!pot.getCodeName().equals(name)) continue;
                return pot;
            }
            return MODERATE;
        }
    }
}

