/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.function.Supplier;
import lotr.common.init.LOTRItems;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public enum VesselType {
    WOODEN_MUG((Supplier<Item>)LOTRItems.WOODEN_MUG, "wooden_mug", "wooden_mug_drink"),
    CERAMIC_MUG((Supplier<Item>)LOTRItems.CERAMIC_MUG, "ceramic_mug", "ceramic_mug_drink"),
    GOLDEN_GOBLET((Supplier<Item>)LOTRItems.GOLDEN_GOBLET, "golden_goblet", "golden_goblet_drink");

    private final Supplier<Item> itemSup;
    private final String vesselName;
    private final String emptyIconName;

    private VesselType(Supplier<Item> item, String name, String iconName) {
        this.itemSup = item;
        this.vesselName = name;
        this.emptyIconName = iconName;
    }

    public ItemStack createEmpty() {
        return new ItemStack((IItemProvider)this.itemSup.get());
    }

    public String getCodeName() {
        return this.vesselName;
    }

    public static VesselType forName(String name) {
        for (VesselType v : VesselType.values()) {
            if (!v.getCodeName().equals(name)) continue;
            return v;
        }
        return WOODEN_MUG;
    }

    public String getEmptyIconName() {
        return this.emptyIconName;
    }

    public ResourceLocation getEmptySpritePath() {
        return new ResourceLocation("lotr", "item/" + this.emptyIconName);
    }
}

