/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class WaterPlantBlockItem
extends BlockItem {
    public WaterPlantBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this.canAttemptPlaceNormally(context)) {
            return super.func_195939_a(context);
        }
        return ActionResultType.PASS;
    }

    protected boolean canAttemptPlaceNormally(ItemUseContext context) {
        return false;
    }

    protected boolean canPlaceOnIce() {
        return false;
    }

    protected void playPlaceSound(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        this.playNormalPlaceSound(world, pos, state, player);
    }

    protected final void playNormalPlaceSound(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        SoundType sound = state.getSoundType((IWorldReader)world, pos, (Entity)player);
        world.func_184133_a(player, pos, this.getPlaceSound(state, world, pos, player), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        RayTraceResult target = WaterPlantBlockItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (target.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)heldItem);
        }
        if (target.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTarget = (BlockRayTraceResult)target;
            BlockPos pos = blockTarget.func_216350_a();
            Direction targetFace = blockTarget.func_216354_b();
            if (!world.func_175660_a(player, pos) || !player.func_175151_a(pos.func_177972_a(targetFace), targetFace, heldItem)) {
                return ActionResult.func_226251_d_((Object)heldItem);
            }
            BlockPos posAbove = pos.func_177984_a();
            BlockState targetState = world.func_180495_p(pos);
            Material targetMaterial = targetState.func_185904_a();
            IFluidState targetFluid = world.func_204610_c(pos);
            if ((targetFluid.func_206886_c() == Fluids.field_204546_a || this.canPlaceOnIce() && targetMaterial == Material.field_151588_w) && world.func_175623_d(posAbove)) {
                BlockSnapshot blocksnapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)posAbove);
                BlockState placeState = this.func_179223_d().func_176223_P();
                world.func_180501_a(posAbove, placeState, 11);
                if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                    blocksnapshot.restore(true, false);
                    return ActionResult.func_226251_d_((Object)heldItem);
                }
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, posAbove, heldItem);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                this.playPlaceSound(world, pos, placeState, player);
                return ActionResult.func_226248_a_((Object)heldItem);
            }
        }
        return ActionResult.func_226251_d_((Object)heldItem);
    }
}

