/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRGameRules;
import lotr.common.LOTRLog;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.init.LOTRWorldTypes;
import lotr.common.item.RedBookItem;
import lotr.common.stat.LOTRStats;
import lotr.common.util.UsernameHelper;
import lotr.common.world.map.CustomWaypoint;
import lotr.common.world.map.CustomWaypointStructureHandler;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class CPacketCreateCustomWaypoint {
    private final String name;
    private final String lore;
    private final boolean isPublic;

    public CPacketCreateCustomWaypoint(String name, String lore, boolean isPublic) {
        this.name = name;
        this.lore = lore;
        this.isPublic = isPublic;
    }

    public static void encode(CPacketCreateCustomWaypoint packet, PacketBuffer buf) {
        buf.func_180714_a(packet.name);
        buf.func_180714_a(packet.lore);
        buf.writeBoolean(packet.isPublic);
    }

    public static CPacketCreateCustomWaypoint decode(PacketBuffer buf) {
        String name = buf.func_150789_c(40);
        String lore = buf.func_150789_c(160);
        boolean isPublic = buf.readBoolean();
        return new CPacketCreateCustomWaypoint(name, lore, isPublic);
    }

    public static void handle(CPacketCreateCustomWaypoint packet, Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        FastTravelDataModule ftData = LOTRLevelData.serverInstance().getData((PlayerEntity)player).getFastTravelData();
        CPacketCreateCustomWaypoint.doCreateCustomWaypoint(packet, player, ftData);
        context.get().setPacketHandled(true);
    }

    private static void doCreateCustomWaypoint(CPacketCreateCustomWaypoint packet, ServerPlayerEntity player, FastTravelDataModule ftData) {
        World world = player.field_70170_p;
        if (!world.func_82736_K().func_223586_b(LOTRGameRules.CUSTOM_WAYPOINT_CREATION)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.create.disabled.gamerule", new Object[0]));
            return;
        }
        if (!LOTRWorldTypes.hasMapFeatures((IWorld)world)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.create.disabled.worldtype", new Object[0]));
            return;
        }
        if (!ftData.canCreateOrAdoptMoreCustomWaypoints()) {
            LOTRLog.warn("Player %s tried to create a custom waypoint but has reached their limit", UsernameHelper.getRawUsername((PlayerEntity)player));
            return;
        }
        String waypointName = packet.name.trim();
        String waypointLore = packet.lore.trim();
        if (waypointName.isEmpty()) {
            LOTRLog.warn("Player %s tried to create a custom waypoint with a blank name", UsernameHelper.getRawUsername((PlayerEntity)player));
            return;
        }
        if (waypointName.length() > 40) {
            LOTRLog.warn("Player %s tried to create a custom waypoint with a name too long (%s)", UsernameHelper.getRawUsername((PlayerEntity)player), waypointName);
            return;
        }
        if (waypointLore.length() > 160) {
            LOTRLog.warn("Player %s tried to create a custom waypoint with lore too long (%s)", UsernameHelper.getRawUsername((PlayerEntity)player), waypointLore);
            return;
        }
        boolean isPublic = packet.isPublic;
        BlockPos waypointPos = CustomWaypointStructureHandler.INSTANCE.getPlayerClickedOnBlockToCreate((PlayerEntity)player);
        if (waypointPos == null) {
            LOTRLog.warn("Player %s tried to create a custom waypoint without having clicked on a block", UsernameHelper.getRawUsername((PlayerEntity)player));
            return;
        }
        Vec3d playerPos = player.func_213303_ch();
        if (waypointPos.func_218138_a((IPosition)playerPos, false) >= 64.0) {
            LOTRLog.warn("Player %s tried to create a custom waypoint on a block too far away (player pos = %s, clicked pos = %s)", UsernameHelper.getRawUsername((PlayerEntity)player), playerPos.toString(), waypointPos.toString());
            return;
        }
        if (!CustomWaypointStructureHandler.INSTANCE.isFocalPointOfCompletableStructure(world, waypointPos)) {
            LOTRLog.warn("Player %s tried to create a custom waypoint without a completed structure (player pos = %s, clicked pos = %s)", UsernameHelper.getRawUsername((PlayerEntity)player), playerPos.toString(), waypointPos.toString());
            return;
        }
        if (CustomWaypointStructureHandler.INSTANCE.hasAdjacentWaypointMarker(world, waypointPos)) {
            LOTRLog.warn("Player %s tried to create a custom waypoint at an already completed structure (player pos = %s, clicked pos = %s)", UsernameHelper.getRawUsername((PlayerEntity)player), playerPos.toString(), waypointPos.toString());
            return;
        }
        CustomWaypointStructureHandler.INSTANCE.clearPlayerClickedOnBlockToCreate((PlayerEntity)player);
        CustomWaypoint createdWaypoint = ftData.createNewCustomWaypoint(waypointName, waypointLore, isPublic, waypointPos);
        CustomWaypointStructureHandler.INSTANCE.completeStructureWithCreatedWaypoint((PlayerEntity)player, createdWaypoint);
        player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.create", new Object[]{waypointName, ftData.getNumCustomWaypoints(), ftData.getMaxCustomWaypoints()}));
        RedBookItem.playCompleteWaypointActionSound(world, waypointPos);
        player.func_195066_a(LOTRStats.CREATE_CUSTOM_WAYPOINT);
    }
}

