/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.UUID;
import java.util.function.Supplier;
import lotr.common.LOTRGameRules;
import lotr.common.LOTRLog;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.init.LOTRWorldTypes;
import lotr.common.util.UsernameHelper;
import lotr.common.world.map.AbstractCustomWaypoint;
import lotr.common.world.map.AdoptedCustomWaypoint;
import lotr.common.world.map.AdoptedCustomWaypointKey;
import lotr.common.world.map.CustomWaypoint;
import lotr.common.world.map.CustomWaypointStructureHandler;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.MapWaypoint;
import lotr.common.world.map.Waypoint;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class CPacketFastTravel {
    private final boolean isCustom;
    private final int waypointID;
    private final UUID adoptedFromPlayer;

    private CPacketFastTravel(boolean custom, int wpID, UUID adoptedFrom) {
        this.isCustom = custom;
        this.waypointID = wpID;
        this.adoptedFromPlayer = adoptedFrom;
    }

    public CPacketFastTravel(Waypoint waypoint) {
        if (waypoint instanceof MapWaypoint) {
            MapWaypoint mapWp = (MapWaypoint)waypoint;
            this.isCustom = false;
            this.waypointID = mapWp.getAssignedId();
            this.adoptedFromPlayer = null;
        } else if (waypoint instanceof CustomWaypoint) {
            CustomWaypoint cwp = (CustomWaypoint)waypoint;
            this.isCustom = true;
            this.waypointID = cwp.getCustomId();
            this.adoptedFromPlayer = null;
        } else if (waypoint instanceof AdoptedCustomWaypoint) {
            AdoptedCustomWaypoint cwp = (AdoptedCustomWaypoint)waypoint;
            this.isCustom = true;
            AdoptedCustomWaypointKey key = cwp.getAdoptedKey();
            this.waypointID = key.getWaypointId();
            this.adoptedFromPlayer = key.getCreatedPlayer();
        } else {
            throw new IllegalArgumentException("Fast travel packet to waypoint type " + waypoint.getClass().getName() + " not supported yet");
        }
    }

    public static void encode(CPacketFastTravel packet, PacketBuffer buf) {
        buf.writeBoolean(packet.isCustom);
        buf.func_150787_b(packet.waypointID);
        boolean isAdoptedFrom = packet.adoptedFromPlayer != null;
        buf.writeBoolean(isAdoptedFrom);
        if (isAdoptedFrom) {
            buf.func_179252_a(packet.adoptedFromPlayer);
        }
    }

    public static CPacketFastTravel decode(PacketBuffer buf) {
        boolean isCustom = buf.readBoolean();
        int waypointID = buf.func_150792_a();
        UUID adoptedFromPlayer = null;
        boolean isAdoptedFrom = buf.readBoolean();
        if (isAdoptedFrom) {
            adoptedFromPlayer = buf.func_179253_g();
        }
        return new CPacketFastTravel(isCustom, waypointID, adoptedFromPlayer);
    }

    public static void handle(CPacketFastTravel packet, Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        World world = player.field_70170_p;
        if (!world.func_82736_K().func_223586_b(LOTRGameRules.FAST_TRAVEL)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.lotr.ft.disabled.gamerule", new Object[0]));
        } else if (!LOTRWorldTypes.hasMapFeatures((IWorld)world)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.lotr.ft.disabled.worldtype", new Object[0]));
        } else {
            LOTRPlayerData playerData = LOTRLevelData.serverInstance().getData((PlayerEntity)player);
            FastTravelDataModule ftData = playerData.getFastTravelData();
            Waypoint waypoint = packet.isCustom ? CPacketFastTravel.interpretCustomWaypoint((PlayerEntity)player, ftData, packet) : CPacketFastTravel.interpretMapWaypoint((PlayerEntity)player, packet);
            if (waypoint != null) {
                if (waypoint.hasPlayerUnlocked((PlayerEntity)player)) {
                    if (ftData.getTimeSinceFT() < ftData.getWaypointFTTime(waypoint, (PlayerEntity)player)) {
                        player.func_71053_j();
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.lotr.ft.moreTime", new Object[]{waypoint.getDisplayName()}));
                    } else {
                        boolean underAttack = ftData.isUnderAttack(player);
                        if (underAttack) {
                            player.func_71053_j();
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.lotr.ft.underAttack", new Object[0]));
                        } else {
                            ftData.setTargetWaypoint(waypoint);
                        }
                    }
                } else {
                    LOTRLog.warn("Player %s tried to FT to a waypoint (%s, %s) that they haven't unlocked", UsernameHelper.getRawUsername((PlayerEntity)player), waypoint.getClass().getSimpleName(), waypoint.getRawName());
                }
            }
        }
        context.get().setPacketHandled(true);
    }

    private static MapWaypoint interpretMapWaypoint(PlayerEntity player, CPacketFastTravel packet) {
        int waypointID = packet.waypointID;
        MapWaypoint waypoint = MapSettingsManager.serverInstance().getCurrentLoadedMap().getWaypointByID(waypointID);
        if (waypoint == null) {
            LOTRLog.warn("Player %s tried to FT to a nonexistent map waypoint ID (%d)", UsernameHelper.getRawUsername(player), waypointID);
        }
        return waypoint;
    }

    private static AbstractCustomWaypoint interpretCustomWaypoint(PlayerEntity player, FastTravelDataModule ftData, CPacketFastTravel packet) {
        int waypointID = packet.waypointID;
        AbstractCustomWaypoint customWp = null;
        UUID adoptedFromPlayer = packet.adoptedFromPlayer;
        if (adoptedFromPlayer != null) {
            customWp = ftData.getAdoptedCustomWaypointByKey(AdoptedCustomWaypointKey.of(adoptedFromPlayer, waypointID));
            if (customWp == null) {
                LOTRLog.warn("Player %s tried to FT to a nonexistent adopted custom waypoint (creator %s, ID %d)", UsernameHelper.getRawUsername(player), adoptedFromPlayer, waypointID);
                return null;
            }
        } else {
            customWp = ftData.getCustomWaypointById(waypointID);
            if (customWp == null) {
                LOTRLog.warn("Player %s tried to FT to a nonexistent custom waypoint ID (%d)", UsernameHelper.getRawUsername(player), waypointID);
                return null;
            }
        }
        if (CustomWaypointStructureHandler.INSTANCE.checkCompletedWaypointHasMarkerAndHandleIfNot(player.field_70170_p, customWp, player)) {
            return customWp;
        }
        return null;
    }
}

