/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.MiscDataModule;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CPacketToggleShowMapLocation {
    private final boolean showMapLocation;

    public CPacketToggleShowMapLocation(boolean showMapLocation) {
        this.showMapLocation = showMapLocation;
    }

    public static void encode(CPacketToggleShowMapLocation packet, PacketBuffer buf) {
        buf.writeBoolean(packet.showMapLocation);
    }

    public static CPacketToggleShowMapLocation decode(PacketBuffer buf) {
        boolean showMapLocation = buf.readBoolean();
        return new CPacketToggleShowMapLocation(showMapLocation);
    }

    public static void handle(CPacketToggleShowMapLocation packet, Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        MiscDataModule miscData = LOTRLevelData.serverInstance().getData((PlayerEntity)player).getMiscData();
        miscData.setShowMapLocation(packet.showMapLocation);
        context.get().setPacketHandled(true);
    }
}

