/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.data.AlignmentDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionSettings;
import lotr.common.world.fac.FactionSettingsManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPacketPledgeBreak {
    private final int cooldown;
    private final int cooldownStart;
    private final Faction brokenFaction;

    public SPacketPledgeBreak(int cooldown, int cooldownStart, Faction brokenFaction) {
        this.cooldown = cooldown;
        this.cooldownStart = cooldownStart;
        this.brokenFaction = brokenFaction;
    }

    public static void encode(SPacketPledgeBreak packet, PacketBuffer buf) {
        buf.writeInt(packet.cooldown);
        buf.writeInt(packet.cooldownStart);
        Faction fac = packet.brokenFaction;
        if (fac != null) {
            buf.writeInt(fac.getAssignedId());
        } else {
            buf.writeInt(-1);
        }
    }

    public static SPacketPledgeBreak decode(PacketBuffer buf) {
        Faction brokenFaction;
        FactionSettings facSettings = FactionSettingsManager.clientInstance().getCurrentLoadedFactions();
        int cooldown = buf.readInt();
        int cooldownStart = buf.readInt();
        int factionId = buf.readInt();
        if (factionId >= 0) {
            brokenFaction = facSettings.getFactionByID(factionId);
            if (brokenFaction == null) {
                LOTRLog.warn("Received nonexistent broken pledge faction ID %d from server", factionId);
            }
        } else {
            brokenFaction = null;
        }
        return new SPacketPledgeBreak(cooldown, cooldownStart, brokenFaction);
    }

    public static void handle(SPacketPledgeBreak packet, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = LOTRMod.proxy.getClientPlayer();
        LOTRPlayerData pd = LOTRLevelData.clientInstance().getData(player);
        AlignmentDataModule alignData = pd.getAlignmentData();
        alignData.setPledgeBreakCooldown(packet.cooldown);
        alignData.setPledgeBreakCooldownStart(packet.cooldownStart);
        alignData.setBrokenPledgeFaction(packet.brokenFaction);
        context.get().setPacketHandled(true);
    }
}

