/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.fac.RankGender;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPacketPreferredRankGender {
    private final RankGender preferredRankGender;

    public SPacketPreferredRankGender(RankGender gender) {
        this.preferredRankGender = gender;
    }

    public static void encode(SPacketPreferredRankGender packet, PacketBuffer buf) {
        buf.func_150787_b(packet.preferredRankGender.networkID);
    }

    public static SPacketPreferredRankGender decode(PacketBuffer buf) {
        int genderId = buf.func_150792_a();
        RankGender preferredRankGender = RankGender.forNetworkID(genderId);
        if (preferredRankGender == null) {
            LOTRLog.warn("Received nonexistent preferred rank gender ID %d from server", genderId);
        }
        return new SPacketPreferredRankGender(preferredRankGender);
    }

    public static void handle(SPacketPreferredRankGender packet, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = LOTRMod.proxy.getClientPlayer();
        LOTRPlayerData pd = LOTRLevelData.clientInstance().getData(player);
        RankGender preferredRankGender = packet.preferredRankGender;
        if (preferredRankGender != null) {
            pd.getMiscData().setPreferredRankGender(preferredRankGender);
        }
        context.get().setPacketHandled(true);
    }
}

