/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import java.util.UUID;
import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.world.map.AdoptedCustomWaypoint;
import lotr.common.world.map.AdoptedCustomWaypointKey;
import lotr.common.world.map.CustomWaypoint;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.MapWaypoint;
import lotr.common.world.map.Waypoint;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SPacketWaypointUseCount {
    private final boolean isCustom;
    private final int waypointID;
    private final UUID adoptedFromPlayer;
    private final int useCount;

    private SPacketWaypointUseCount(boolean custom, int wpID, UUID adoptedFrom, int count) {
        this.isCustom = custom;
        this.waypointID = wpID;
        this.useCount = count;
        this.adoptedFromPlayer = adoptedFrom;
    }

    public SPacketWaypointUseCount(Waypoint waypoint, int count) {
        if (waypoint instanceof MapWaypoint) {
            MapWaypoint mapWp = (MapWaypoint)waypoint;
            this.isCustom = false;
            this.waypointID = mapWp.getAssignedId();
            this.adoptedFromPlayer = null;
        } else if (waypoint instanceof CustomWaypoint) {
            CustomWaypoint cwp = (CustomWaypoint)waypoint;
            this.isCustom = true;
            this.waypointID = cwp.getCustomId();
            this.adoptedFromPlayer = null;
        } else if (waypoint instanceof AdoptedCustomWaypoint) {
            AdoptedCustomWaypoint cwp = (AdoptedCustomWaypoint)waypoint;
            this.isCustom = true;
            AdoptedCustomWaypointKey key = cwp.getAdoptedKey();
            this.waypointID = key.getWaypointId();
            this.adoptedFromPlayer = key.getCreatedPlayer();
        } else {
            throw new IllegalArgumentException("Use count packet for waypoint type " + waypoint.getClass().getName() + " not supported yet");
        }
        this.useCount = count;
    }

    public static void encode(SPacketWaypointUseCount packet, PacketBuffer buf) {
        buf.writeBoolean(packet.isCustom);
        buf.func_150787_b(packet.waypointID);
        boolean isAdoptedFrom = packet.adoptedFromPlayer != null;
        buf.writeBoolean(isAdoptedFrom);
        if (isAdoptedFrom) {
            buf.func_179252_a(packet.adoptedFromPlayer);
        }
        buf.func_150787_b(packet.useCount);
    }

    public static SPacketWaypointUseCount decode(PacketBuffer buf) {
        boolean isCustom = buf.readBoolean();
        int waypointID = buf.func_150792_a();
        UUID adoptedFromPlayer = null;
        boolean isAdoptedFrom = buf.readBoolean();
        if (isAdoptedFrom) {
            adoptedFromPlayer = buf.func_179253_g();
        }
        int useCount = buf.func_150792_a();
        return new SPacketWaypointUseCount(isCustom, waypointID, adoptedFromPlayer, useCount);
    }

    public static void handle(SPacketWaypointUseCount packet, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = LOTRMod.proxy.getClientPlayer();
        LOTRPlayerData pd = LOTRLevelData.clientInstance().getData(player);
        FastTravelDataModule ftData = pd.getFastTravelData();
        if (packet.isCustom) {
            if (packet.adoptedFromPlayer != null) {
                AdoptedCustomWaypointKey key = AdoptedCustomWaypointKey.of(packet.adoptedFromPlayer, packet.waypointID);
                AdoptedCustomWaypoint cwp = ftData.getAdoptedCustomWaypointByKey(key);
                if (cwp != null) {
                    ftData.setWPUseCount(cwp, packet.useCount);
                } else {
                    LOTRLog.warn("Received nonexistent adopted custom waypoint (creator %s, ID %d) from server", key.getCreatedPlayer(), key.getWaypointId());
                }
            } else {
                int cwpID = packet.waypointID;
                CustomWaypoint cwp = ftData.getCustomWaypointById(cwpID);
                if (cwp != null) {
                    ftData.setWPUseCount(cwp, packet.useCount);
                } else {
                    LOTRLog.warn("Received nonexistent custom waypoint ID %d from server", cwpID);
                }
            }
        } else {
            int wpID = packet.waypointID;
            MapWaypoint mapWp = MapSettingsManager.clientInstance().getCurrentLoadedMap().getWaypointByID(wpID);
            if (mapWp != null) {
                ftData.setWPUseCount(mapWp, packet.useCount);
            } else {
                LOTRLog.warn("Received nonexistent map waypoint ID %d from server", wpID);
            }
        }
        context.get().setPacketHandled(true);
    }
}

