/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.recipe;

import lotr.common.recipe.LOTRRecipes;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class DrinkBrewingRecipe
implements IRecipe<IInventory> {
    protected final ResourceLocation recipeId;
    protected final String group;
    protected final NonNullList<Ingredient> ingredients;
    protected final ItemStack result;
    protected final float experience;
    protected final int brewTime;

    public DrinkBrewingRecipe(ResourceLocation i, String grp, NonNullList<Ingredient> ingr, ItemStack res, float xp, int time) {
        this.recipeId = i;
        this.group = grp;
        this.ingredients = ingr;
        this.result = res;
        this.experience = xp;
        this.brewTime = time;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        int waters;
        int invSize = inv.func_70302_i_();
        int invSizeToCheck = invSize - (waters = 3);
        if (invSizeToCheck > this.ingredients.size()) {
            return false;
        }
        boolean[] matchedSlots = new boolean[invSizeToCheck];
        for (Ingredient ing : this.ingredients) {
            boolean matchedIngredient = false;
            for (int i = 0; i < invSizeToCheck; ++i) {
                ItemStack stackInSlot;
                if (matchedSlots[i] || !ing.test(stackInSlot = inv.func_70301_a(i))) continue;
                matchedIngredient = true;
                matchedSlots[i] = true;
                break;
            }
            if (matchedIngredient) continue;
            return false;
        }
        for (int i = 0; i < waters; ++i) {
            int waterSlot = invSizeToCheck + i;
            if (DrinkBrewingRecipe.isWaterSource(inv.func_70301_a(waterSlot))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWaterSource(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151131_as;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public float getExperience() {
        return this.experience;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public String func_193358_e() {
        return this.group;
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeType<?> func_222127_g() {
        return LOTRRecipes.DRINK_BREWING;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)LOTRRecipes.DRINK_BREWING_SERIALIZER.get();
    }
}

