/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.recipe.MultiTableType;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;

public class FactionTableType
implements IRecipeType<ICraftingRecipe> {
    public final String recipeID;
    private final Supplier<Block> blockIconSupplier;
    private final List<MultiTableType> multiTypes = new ArrayList<MultiTableType>();

    public FactionTableType(String s, Supplier<Block> blockSup) {
        this.recipeID = s;
        this.blockIconSupplier = blockSup;
    }

    public String toString() {
        return this.recipeID;
    }

    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)this.blockIconSupplier.get());
    }

    public void registerMultiTableType(MultiTableType t) {
        if (!t.tableTypes.contains(this)) {
            throw new IllegalArgumentException("Invalid - multi table type " + t.toString() + " does not include faction table " + this.toString() + "!");
        }
        if (!this.multiTypes.contains(t)) {
            this.multiTypes.add(t);
        } else {
            LOTRLog.warn("Faction table type %s already includes multi table type %s", this.toString(), t.toString());
        }
    }

    public List<MultiTableType> getMultiTableTypes() {
        return this.multiTypes;
    }
}

