/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.recipe;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import lotr.common.recipe.FactionTableType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;

public class MultiTableType
implements IRecipeType<ICraftingRecipe> {
    public final String recipeID;
    public final List<FactionTableType> tableTypes;
    private static Random rand = new Random();
    private FactionTableType randTableType;
    private long lastRandomTime;

    public MultiTableType(String s, FactionTableType ... types) {
        this.recipeID = s;
        this.tableTypes = Arrays.asList(types);
        for (FactionTableType facType : types) {
            facType.registerMultiTableType(this);
        }
    }

    public String toString() {
        return this.recipeID;
    }

    public ItemStack getRandomFactionIcon() {
        if (this.randTableType == null || System.currentTimeMillis() - this.lastRandomTime > 1000L) {
            this.randTableType = this.tableTypes.get(rand.nextInt(this.tableTypes.size()));
            this.lastRandomTime = System.currentTimeMillis();
        }
        return this.randTableType.getIcon();
    }
}

