/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import lotr.common.init.LOTRTags;
import lotr.common.inv.SlotAndCount;
import lotr.common.recipe.AbstractAlloyForgeRecipe;
import lotr.common.util.LOTRUtil;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractAlloyForgeTileEntity
extends LockableTileEntity
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity {
    public static final int RECIPE_FUNCTIONALITY_VERSION_FOR_JEI = 3;
    private int[] SLOTS_INGREDIENT = new int[]{0, 1, 2, 3};
    private int[] SLOTS_ALLOY = new int[]{4, 5, 6, 7};
    private int[] SLOTS_OUTPUT = new int[]{8, 9, 10, 11};
    private int SLOT_FUEL = 12;
    protected NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)(this.SLOTS_INGREDIENT.length + this.SLOTS_ALLOY.length + this.SLOTS_OUTPUT.length + 1), (Object)ItemStack.field_190927_a);
    private int burnTime;
    private int burnTimeTotal;
    private int cookTime;
    private int cookTimeTotal;
    protected final IIntArray forgeData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractAlloyForgeTileEntity.this.burnTime;
                }
                case 1: {
                    return AbstractAlloyForgeTileEntity.this.burnTimeTotal;
                }
                case 2: {
                    return AbstractAlloyForgeTileEntity.this.cookTime;
                }
                case 3: {
                    return AbstractAlloyForgeTileEntity.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractAlloyForgeTileEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    AbstractAlloyForgeTileEntity.this.burnTimeTotal = value;
                    break;
                }
                case 2: {
                    AbstractAlloyForgeTileEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    AbstractAlloyForgeTileEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    private final Map<ResourceLocation, Integer> usedRecipes = Maps.newHashMap();
    protected final IRecipeType<? extends AbstractCookingRecipe>[] recipeTypes;
    protected final IRecipeType<? extends AbstractAlloyForgeRecipe>[] alloyRecipeTypes;
    private LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected AbstractAlloyForgeTileEntity(TileEntityType<?> type, IRecipeType<? extends AbstractCookingRecipe>[] recipes, IRecipeType<? extends AbstractAlloyForgeRecipe>[] alloyRecipes) {
        super(type);
        this.recipeTypes = recipes;
        this.alloyRecipeTypes = alloyRecipes;
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
        this.burnTime = nbt.func_74762_e("BurnTime");
        this.cookTime = nbt.func_74762_e("CookTime");
        this.cookTimeTotal = nbt.func_74762_e("CookTimeTotal");
        this.burnTimeTotal = this.getBurnTime((ItemStack)this.inventory.get(this.SLOT_FUEL));
        int rSize = nbt.func_74765_d("RecipesUsedSize");
        for (int ri = 0; ri < rSize; ++ri) {
            ResourceLocation res = new ResourceLocation(nbt.func_74779_i("RecipeLocation" + ri));
            int count = nbt.func_74762_e("RecipeAmount" + ri);
            this.usedRecipes.put(res, count);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("BurnTime", this.burnTime);
        nbt.func_74768_a("CookTime", this.cookTime);
        nbt.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        nbt.func_74777_a("RecipesUsedSize", (short)this.usedRecipes.size());
        int ri = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : this.usedRecipes.entrySet()) {
            nbt.func_74778_a("RecipeLocation" + ri, entry.getKey().toString());
            nbt.func_74768_a("RecipeAmount" + ri, entry.getValue().intValue());
            ++ri;
        }
        return nbt;
    }

    public void func_73660_a() {
        boolean wasBurning = this.isBurning();
        boolean needUpdate = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuelItem = (ItemStack)this.inventory.get(this.SLOT_FUEL);
            boolean anyIngredients = false;
            for (int i : this.SLOTS_INGREDIENT) {
                if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                anyIngredients = true;
                break;
            }
            if (this.isBurning() || !fuelItem.func_190926_b() && anyIngredients) {
                if (!this.isBurning() && this.canDoSmelting()) {
                    this.burnTimeTotal = this.burnTime = this.getBurnTime(fuelItem);
                    if (this.isBurning()) {
                        needUpdate = true;
                        if (fuelItem.hasContainerItem()) {
                            this.inventory.set(this.SLOT_FUEL, (Object)fuelItem.getContainerItem());
                        } else if (!fuelItem.func_190926_b()) {
                            Item item = fuelItem.func_77973_b();
                            fuelItem.func_190918_g(1);
                            if (fuelItem.func_190926_b()) {
                                this.inventory.set(this.SLOT_FUEL, (Object)fuelItem.getContainerItem());
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canDoSmelting()) {
                    ++this.cookTime;
                    if (this.cookTime == this.cookTimeTotal) {
                        this.cookTime = 0;
                        this.cookTimeTotal = this.getCookTime();
                        this.doSmelt();
                        needUpdate = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            if (wasBurning != this.isBurning()) {
                needUpdate = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(this.isBurning())), 3);
            }
        }
        if (needUpdate) {
            this.func_70296_d();
        }
    }

    protected boolean canDoSmelting() {
        for (int i = 0; i < this.SLOTS_INGREDIENT.length; ++i) {
            int slotI = this.SLOTS_INGREDIENT[i];
            int slotA = this.SLOTS_ALLOY[i];
            int slotO = this.SLOTS_OUTPUT[i];
            if (!this.canSmelt(slotI, slotA, slotO)) continue;
            return true;
        }
        return false;
    }

    protected boolean canSmelt(int slotIngredient, int slotAlloy, int slotOutput) {
        ItemStack output = this.getSmeltingResult((ItemStack)this.inventory.get(slotIngredient), (ItemStack)this.inventory.get(slotAlloy));
        if (output.func_190926_b()) {
            return false;
        }
        ItemStack existingOutput = (ItemStack)this.inventory.get(slotOutput);
        if (existingOutput.func_190926_b()) {
            return true;
        }
        if (!existingOutput.func_77969_a(output)) {
            return false;
        }
        if (existingOutput.func_190916_E() + output.func_190916_E() <= this.func_70297_j_() && existingOutput.func_190916_E() + output.func_190916_E() <= existingOutput.func_77976_d()) {
            return true;
        }
        return existingOutput.func_190916_E() + output.func_190916_E() <= output.func_77976_d();
    }

    public final ItemStack getSmeltingResult(ItemStack ingredientStack, ItemStack alloyStack) {
        if (ingredientStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!alloyStack.func_190926_b()) {
            Inventory alloyTestInv = new Inventory(2);
            alloyTestInv.func_70299_a(0, ingredientStack);
            alloyTestInv.func_70299_a(1, alloyStack);
            for (IRecipeType<? extends AbstractAlloyForgeRecipe> recipeType : this.alloyRecipeTypes) {
                IRecipe alloyRecipe = this.field_145850_b.func_199532_z().func_215371_a(recipeType, (IInventory)alloyTestInv, this.field_145850_b).orElse(null);
                if (alloyRecipe == null) continue;
                ItemStack output = alloyRecipe.func_77571_b();
                return output;
            }
        } else {
            Inventory furnaceTestInv = new Inventory(1);
            furnaceTestInv.func_70299_a(0, ingredientStack);
            for (IRecipeType<? extends AbstractCookingRecipe> recipeType : this.recipeTypes) {
                IRecipe furnaceRecipe = this.field_145850_b.func_199532_z().func_215371_a(recipeType, (IInventory)furnaceTestInv, this.field_145850_b).orElse(null);
                if (furnaceRecipe == null) continue;
                ItemStack output = furnaceRecipe.func_77571_b();
                if (recipeType == IRecipeType.field_222150_b && !this.isDefaultFurnaceRecipeAcceptable(ingredientStack, output)) continue;
                return output;
            }
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isDefaultFurnaceRecipeAcceptable(ItemStack ingredientStack, ItemStack resultStack) {
        Block block;
        Material material;
        Item ingredient = ingredientStack.func_77973_b();
        if (ingredient instanceof BlockItem && ((material = (block = ((BlockItem)ingredient).func_179223_d()).func_176223_P().func_185904_a()) == Material.field_151576_e || material == Material.field_151595_p || material == Material.field_151571_B)) {
            return true;
        }
        return ingredient.func_206844_a(LOTRTags.Items.ALLOY_FORGE_EXTRA_SMELTABLES);
    }

    protected void doSmelt() {
        for (int i = 0; i < this.SLOTS_INGREDIENT.length; ++i) {
            int slotI = this.SLOTS_INGREDIENT[i];
            int slotA = this.SLOTS_ALLOY[i];
            int slotO = this.SLOTS_OUTPUT[i];
            this.smeltItemInSlot(slotI, slotA, slotO);
        }
    }

    private void smeltItemInSlot(int slotIngredient, int slotAlloy, int slotOutput) {
        IRecipe foundRecipe = null;
        boolean isAlloyRecipe = false;
        ItemStack ingredientStack = (ItemStack)this.inventory.get(slotIngredient);
        ItemStack alloyStack = (ItemStack)this.inventory.get(slotAlloy);
        if (!alloyStack.func_190926_b()) {
            Inventory alloyTestInv = new Inventory(2);
            alloyTestInv.func_70299_a(0, ingredientStack);
            alloyTestInv.func_70299_a(1, alloyStack);
            for (IRecipeType<? extends AbstractAlloyForgeRecipe> iRecipeType : this.alloyRecipeTypes) {
                foundRecipe = this.field_145850_b.func_199532_z().func_215371_a(iRecipeType, (IInventory)alloyTestInv, this.field_145850_b).orElse(null);
                if (foundRecipe == null) continue;
                isAlloyRecipe = true;
                break;
            }
        } else {
            Inventory furnaceTestInv = new Inventory(1);
            furnaceTestInv.func_70299_a(0, ingredientStack);
            for (IRecipeType<? extends AbstractCookingRecipe> iRecipeType : this.recipeTypes) {
                foundRecipe = this.field_145850_b.func_199532_z().func_215371_a(iRecipeType, (IInventory)furnaceTestInv, this.field_145850_b).orElse(null);
                if (foundRecipe == null) {
                    continue;
                }
                break;
            }
        }
        if (foundRecipe != null && this.canSmelt(slotIngredient, slotAlloy, slotOutput)) {
            ItemStack output = foundRecipe.func_77571_b();
            ItemStack itemStack = (ItemStack)this.inventory.get(slotOutput);
            if (itemStack.func_190926_b()) {
                this.inventory.set(slotOutput, (Object)output.func_77946_l());
            } else if (itemStack.func_77973_b() == output.func_77973_b()) {
                itemStack.func_190917_f(output.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(foundRecipe);
            }
            if (ingredientStack.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !((ItemStack)this.inventory.get(this.SLOT_FUEL)).func_190926_b() && ((ItemStack)this.inventory.get(this.SLOT_FUEL)).func_77973_b() == Items.field_151133_ar) {
                this.inventory.set(this.SLOT_FUEL, (Object)new ItemStack((IItemProvider)Items.field_151131_as));
            }
            ingredientStack.func_190918_g(1);
            if (isAlloyRecipe) {
                alloyStack.func_190918_g(1);
            }
        }
    }

    protected int getBurnTime(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return 0;
        }
        Item item = itemstack.func_77973_b();
        return ForgeHooks.getBurnTime((ItemStack)itemstack);
    }

    protected int getCookTime() {
        return 400;
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return LOTRUtil.combineArrays(this.SLOTS_OUTPUT, new int[]{this.SLOT_FUEL});
        }
        if (side == Direction.UP) {
            return SlotAndCount.sortSlotsByCount((IInventory)this, this.SLOTS_INGREDIENT);
        }
        return new int[]{this.SLOT_FUEL};
    }

    public boolean func_180462_a(int index, ItemStack stack, Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        Item item;
        return direction != Direction.DOWN || index != this.SLOT_FUEL || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (ArrayUtils.contains((int[])this.SLOTS_INGREDIENT, (int)index)) {
            return true;
        }
        if (index == this.SLOT_FUEL) {
            ItemStack currentFuel = (ItemStack)this.inventory.get(1);
            return AbstractFurnaceTileEntity.func_213991_b((ItemStack)stack) || stack.func_77973_b() == Items.field_151133_ar && currentFuel.func_77973_b() != Items.field_151133_ar;
        }
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        boolean sameItem = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (ArrayUtils.contains((int[])this.SLOTS_INGREDIENT, (int)index) && !sameItem) {
            this.cookTimeTotal = this.getCookTime();
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public void func_193056_a(IRecipe<?> recipe) {
        if (recipe != null) {
            this.usedRecipes.compute(recipe.func_199560_c(), (res, i) -> 1 + (i == null ? 0 : i));
        }
    }

    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void func_201560_d(PlayerEntity player) {
    }

    public void onResultTaken(PlayerEntity player) {
        ArrayList recipes = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, Integer> entry : this.usedRecipes.entrySet()) {
            player.field_70170_p.func_199532_z().func_215367_a(entry.getKey()).ifPresent(recipe -> {
                recipes.add(recipe);
                float xp = 0.0f;
                if (recipe instanceof AbstractCookingRecipe) {
                    xp = ((AbstractCookingRecipe)recipe).func_222138_b();
                } else if (recipe instanceof AbstractAlloyForgeRecipe) {
                    xp = ((AbstractAlloyForgeRecipe)recipe).getExperience();
                }
                LOTRUtil.spawnXPOrbs(player, (Integer)entry.getValue(), xp);
            });
        }
        player.func_195065_a((Collection)recipes);
        this.usedRecipes.clear();
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack itemstack : this.inventory) {
            helper.func_194112_a(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }
}

