/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.time;

import com.google.common.math.IntMath;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import lotr.common.LOTRLog;
import lotr.common.data.LOTRLevelData;
import lotr.common.dim.LOTRDimension;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.SPacketDate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public class LOTRDate {
    private static final long ticksInDay = 48000L;
    private static long prevWorldTime = -1L;
    public static final int SECOND_AGE_LENGTH = 3441;
    public static final int THIRD_AGE_LENGTH = 3021;
    public static final int SHIRE_RECKONING_OFFSET_FROM_THIRD_AGE = -1600;
    public static final int THIRD_AGE_CURRENT = ShireReckoning.START_DATE.year - -1600;

    public static void saveDates(CompoundNBT levelData) {
        CompoundNBT dateData = new CompoundNBT();
        dateData.func_74768_a("ShireDate", ShireReckoning.currentDay);
        levelData.func_218657_a("Dates", (INBT)dateData);
    }

    public static void loadDates(CompoundNBT levelData) {
        if (levelData.func_150297_b("Dates", 10)) {
            CompoundNBT dateData = levelData.func_74775_l("Dates");
            ShireReckoning.currentDay = dateData.func_74762_e("ShireDate");
        } else {
            ShireReckoning.currentDay = 0;
        }
    }

    public static void resetWorldTimeInMenu() {
        prevWorldTime = -1L;
    }

    public static void updateDate(ServerWorld world) {
        long prevDay;
        long day;
        if (!(world.func_201675_m() instanceof LOTRDimension)) {
            return;
        }
        long worldTime = world.func_72820_D();
        if (prevWorldTime == -1L) {
            prevWorldTime = worldTime;
        }
        if ((day = worldTime / 48000L) != (prevDay = prevWorldTime / 48000L)) {
            LOTRDate.setDate(world, ShireReckoning.currentDay + 1);
        }
        prevWorldTime = worldTime;
    }

    public static void setDate(ServerWorld world, int date) {
        ShireReckoning.currentDay = date;
        LOTRLevelData.sidedInstance((IWorldReader)world).markDirty();
        LOTRLog.info("Updating LOTR day: " + ShireReckoning.getShireDate().getDateName(false).func_150254_d());
        for (ServerPlayerEntity player : world.func_73046_m().func_184103_al().func_181057_v()) {
            LOTRDate.sendUpdatePacket(player, true);
        }
    }

    public static void sendUpdatePacket(ServerPlayerEntity player, boolean displayNewDate) {
        CompoundNBT dateData = new CompoundNBT();
        LOTRDate.saveDates(dateData);
        SPacketDate packet = new SPacketDate(dateData, displayNewDate);
        LOTRPacketHandler.sendTo(packet, player);
    }

    public static class ShireReckoning {
        public static final Date START_DATE = new Date(1401, Month.HALIMATH, 22);
        public static int currentDay = 0;
        private static Map<Integer, Date> cachedDates = new HashMap<Integer, Date>();

        public static boolean isLeapYear(int year) {
            return year % 4 == 0 && year % 100 != 0;
        }

        public static Date getShireDate() {
            return ShireReckoning.getShireDate(currentDay);
        }

        public static Date getShireDate(int day) {
            Date date = cachedDates.get(day);
            if (date == null) {
                date = START_DATE.copy();
                if (day < 0) {
                    for (int i = 0; i < -day; ++i) {
                        date = date.decrement();
                    }
                } else {
                    for (int i = 0; i < day; ++i) {
                        date = date.increment();
                    }
                }
                cachedDates.put(day, date);
            }
            return date;
        }

        public static Season getSeason() {
            return ShireReckoning.getShireDate().month.season;
        }

        public static class Date {
            public final int year;
            public final Month month;
            public final int monthDate;
            private Day day;

            public Date(int y, Month m, int d) {
                this.year = y;
                this.month = m;
                this.monthDate = d;
            }

            public ITextComponent getDisplayName(boolean longName) {
                return new TranslationTextComponent("lotr.date.shire.format.dateAndYear", new Object[]{this.getDateName(longName), this.getYearName(longName)});
            }

            public ITextComponent getDateName(boolean longName) {
                Day day = this.getDay();
                if (this.month.isSingleDay()) {
                    if (this.month.hasWeekdayName) {
                        return new TranslationTextComponent("lotr.date.shire.format.weekdayOfSingleDayMonth", new Object[]{day.getDisplayName(), this.month.getDisplayName()});
                    }
                    return new TranslationTextComponent("lotr.date.shire.format.singleDayMonth", new Object[]{this.month.getDisplayName()});
                }
                return new TranslationTextComponent("lotr.date.shire.format.weekdayOfMonth", new Object[]{day.getDisplayName(), this.monthDate, this.month.getDisplayName()});
            }

            public ITextComponent getYearName(boolean longName) {
                TranslationTextComponent yearPrefix = longName ? new TranslationTextComponent("lotr.date.shire.long", new Object[0]) : new TranslationTextComponent("lotr.date.shire.short", new Object[0]);
                return new TranslationTextComponent("lotr.date.shire.format.year", new Object[]{yearPrefix, this.year});
            }

            public Day getDay() {
                if (!this.month.hasWeekdayName) {
                    return null;
                }
                if (this.day == null) {
                    int yearDay = 0;
                    int monthID = this.month.ordinal();
                    for (int i = 0; i < monthID; ++i) {
                        Month m = Month.values()[i];
                        if (!m.hasWeekdayName) continue;
                        yearDay += m.days;
                    }
                    int dayID = IntMath.mod((int)((yearDay += this.monthDate) - 1), (int)Day.values().length);
                    this.day = Day.values()[dayID];
                }
                return this.day;
            }

            public Date copy() {
                return new Date(this.year, this.month, this.monthDate);
            }

            public Date increment() {
                int newYear = this.year;
                Month newMonth = this.month;
                int newDate = this.monthDate;
                if (++newDate > newMonth.days) {
                    newDate = 1;
                    int monthID = newMonth.ordinal();
                    if (++monthID >= Month.values().length) {
                        monthID = 0;
                        ++newYear;
                    }
                    newMonth = Month.values()[monthID];
                    if (newMonth.isLeapYear && !ShireReckoning.isLeapYear(newYear)) {
                        newMonth = Month.values()[++monthID];
                    }
                }
                return new Date(newYear, newMonth, newDate);
            }

            public Date decrement() {
                int newYear = this.year;
                Month newMonth = this.month;
                int newDate = this.monthDate;
                if (--newDate < 0) {
                    int monthID = newMonth.ordinal();
                    if (--monthID < 0) {
                        monthID = Month.values().length - 1;
                        --newYear;
                    }
                    newMonth = Month.values()[monthID];
                    if (newMonth.isLeapYear && !ShireReckoning.isLeapYear(newYear)) {
                        newMonth = Month.values()[--monthID];
                    }
                    newDate = newMonth.days;
                }
                return new Date(newYear, newMonth, newDate);
            }
        }

        public static enum Month {
            YULE_2("yule2", 1, Season.WINTER),
            AFTERYULE("afteryule", 30, Season.WINTER),
            SOLMATH("solmath", 30, Season.WINTER),
            RETHE("rethe", 30, Season.WINTER),
            ASTRON("astron", 30, Season.SPRING),
            THRIMIDGE("thrimidge", 30, Season.SPRING),
            FORELITHE("forelithe", 30, Season.SPRING),
            LITHE_1("lithe1", 1, Season.SPRING),
            MIDYEARSDAY("midyearsday", 1, Season.SUMMER, false, false),
            OVERLITHE("overlithe", 1, Season.SUMMER, false, true),
            LITHE_2("lithe2", 1, Season.SUMMER),
            AFTERLITHE("afterlithe", 30, Season.SUMMER),
            WEDMATH("wedmath", 30, Season.SUMMER),
            HALIMATH("halimath", 30, Season.SUMMER),
            WINTERFILTH("winterfilth", 30, Season.AUTUMN),
            BLOTMATH("blotmath", 30, Season.AUTUMN),
            FOREYULE("foreyule", 30, Season.AUTUMN),
            YULE_1("yule1", 1, Season.AUTUMN);

            private String name;
            public int days;
            public boolean hasWeekdayName;
            public boolean isLeapYear;
            public Season season;

            private Month(String s, int i, Season se) {
                this(s, i, se, true, false);
            }

            private Month(String s, int i, Season se, boolean flag, boolean flag1) {
                this.name = s;
                this.days = i;
                this.hasWeekdayName = flag;
                this.isLeapYear = flag1;
                this.season = se;
            }

            public ITextComponent getDisplayName() {
                return new TranslationTextComponent("lotr.date.shire.month." + this.name, new Object[0]);
            }

            public boolean isSingleDay() {
                return this.days == 1;
            }
        }

        public static enum Day {
            STERDAY("sterday"),
            SUNDAY("sunday"),
            MONDAY("monday"),
            TREWSDAY("trewsday"),
            HEVENSDAY("hevensday"),
            MERSDAY("mersday"),
            HIGHDAY("highday");

            private String name;

            private Day(String s) {
                this.name = s;
            }

            public ITextComponent getDisplayName() {
                return new TranslationTextComponent("lotr.date.shire.day." + this.name, new Object[0]);
            }
        }
    }

    public static enum Season {
        SPRING("spring", 0, new float[]{1.0f, 1.0f, 1.0f}),
        SUMMER("summer", 1, new float[]{1.15f, 1.15f, 0.9f}),
        AUTUMN("autumn", 2, new float[]{1.2f, 1.0f, 0.7f}),
        WINTER("winter", 3, new float[]{1.0f, 0.8f, 0.8f});

        public static Season[] allSeasons;
        private final String name;
        public final int seasonID;
        private final float[] grassRGB;

        private Season(String s, int i, float[] f) {
            this.name = s;
            this.seasonID = i;
            this.grassRGB = f;
        }

        public String codeName() {
            return this.name;
        }

        public int transformColor(int color) {
            float[] rgb = new Color(color).getRGBColorComponents(null);
            float r = rgb[0];
            float g = rgb[1];
            float b = rgb[2];
            r = Math.min(r * this.grassRGB[0], 1.0f);
            g = Math.min(g * this.grassRGB[1], 1.0f);
            b = Math.min(b * this.grassRGB[2], 1.0f);
            return new Color(r, g, b).getRGB();
        }

        static {
            allSeasons = new Season[]{SPRING, SUMMER, AUTUMN, WINTER};
        }
    }
}

