/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class LookupList<T, K>
extends AbstractList<T> {
    private final List<T> list = new ArrayList<T>();
    private final Map<K, T> lookup = new HashMap<K, T>();
    private final Function<T, K> keyExtractor;

    public LookupList(Function<T, K> keyExtractor) {
        this.keyExtractor = keyExtractor;
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T set(int index, T element) {
        this.list.set(index, element);
        this.lookup.put(this.keyExtractor.apply(element), element);
        return element;
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
        this.lookup.put(this.keyExtractor.apply(element), element);
    }

    @Override
    public T remove(int index) {
        T removed = this.list.remove(index);
        if (removed != null) {
            this.lookup.remove(this.keyExtractor.apply(removed));
        }
        return removed;
    }

    public T lookup(K key) {
        return this.lookup.get(key);
    }

    public boolean hasKey(K key) {
        return this.lookup.containsKey(key);
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

