/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world;

import java.util.function.Function;
import lotr.common.data.LOTRLevelData;
import lotr.common.dim.MiddleEarthDimension;
import lotr.common.entity.item.RingPortalEntity;
import lotr.common.init.LOTRDimensions;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class RingPortalTeleporter
implements ITeleporter {
    private DimensionType targetDim;
    private boolean makeRingPortalIfNotMade;

    public RingPortalTeleporter(DimensionType dim, boolean make) {
        this.targetDim = dim;
        this.makeRingPortalIfNotMade = make;
    }

    public static void transferEntity(Entity entity, boolean makePortal) {
        DimensionType targetDim = LOTRDimensions.middleEarth();
        if (entity.field_71093_bK == targetDim) {
            targetDim = DimensionType.field_223227_a_;
        }
        entity.changeDimension(targetDim, (ITeleporter)new RingPortalTeleporter(targetDim, makePortal));
    }

    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        BlockPos target;
        LOTRLevelData levelData = LOTRLevelData.serverInstance();
        if (this.targetDim == LOTRDimensions.middleEarth()) {
            if (levelData.madeMiddleEarthPortal()) {
                target = levelData.getMiddleEarthPortalLocation();
            } else {
                MiddleEarthDimension meDim = (MiddleEarthDimension)currentWorld.func_73046_m().func_71218_a(LOTRDimensions.middleEarth()).func_201675_m();
                target = meDim.getDefaultPortalCoordinate();
            }
        } else {
            target = levelData.getOverworldPortalLocation();
        }
        while (destWorld.func_180495_p(target).func_200132_m()) {
            target = target.func_177984_a();
        }
        while (!destWorld.func_180495_p(target.func_177977_b()).func_200132_m()) {
            target = target.func_177977_b();
        }
        Vec3d prevMotion = entity.func_213322_ci();
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.func_70012_b((double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5, player.field_70177_z, 0.0f);
            player.func_70029_a((World)destWorld);
            destWorld.func_217447_b(player);
            DimensionType oldDimType = currentWorld.field_73011_w.func_186058_p();
            DimensionType newDimType = player.field_70170_p.field_73011_w.func_186058_p();
            CriteriaTriggers.field_193134_u.func_193143_a(player, oldDimType, newDimType);
            player.field_71135_a.func_147364_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
        } else {
            Entity entityNew = entity.func_200600_R().func_200721_a((World)destWorld);
            if (entityNew != null) {
                entityNew.func_180432_n(entity);
                entityNew.func_174828_a(target, entityNew.field_70177_z, 0.0f);
                entityNew.func_213317_d(prevMotion);
                destWorld.func_217460_e(entity);
            }
            entity = entityNew;
            entity.field_71088_bW = entity.func_82147_ab();
        }
        if (this.targetDim == LOTRDimensions.middleEarth() && !levelData.madeMiddleEarthPortal()) {
            if (this.makeRingPortalIfNotMade) {
                RingPortalEntity portal = new RingPortalEntity((World)destWorld);
                portal.func_70012_b((double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 3.5, (double)target.func_177952_p() + 0.5, 0.0f, 0.0f);
                destWorld.func_217376_c((Entity)portal);
            }
            levelData.setMadeMiddleEarthPortal(true);
            levelData.markMiddleEarthPortalLocation((World)destWorld, target);
        }
        entity.field_71088_bW = entity.func_82147_ab();
        return entity;
    }
}

