/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.BaseGondorBiome;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;

public class AnfalasBiome
extends BaseGondorBiome {
    public AnfalasBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.08f).func_205420_b(0.15f).func_205414_c(0.9f).func_205417_d(0.9f), major);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        super.setupSurface(config);
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            double noise1 = config.getNoise1(x, (int)((double)z * 8.0), 0.008);
            double noise2 = config.getNoise1(x, (int)((double)z * 2.333), 0.3);
            if (noise1 + (noise2 *= 0.4) > 0.8) {
                return Blocks.field_150354_m.func_176223_P();
            }
            return in;
        });
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.05f, TreeCluster.of(8, 25), LOTRBiomeFeatures.oak(), 5000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakBees(), 50, LOTRBiomeFeatures.oakFancyBees(), 10, LOTRBiomeFeatures.birch(), 1000, LOTRBiomeFeatures.birchFancy(), 500, LOTRBiomeFeatures.birchBees(), 10, LOTRBiomeFeatures.birchFancyBees(), 5, LOTRBiomeFeatures.cypress(), 4000, LOTRBiomeFeatures.apple(), 50, LOTRBiomeFeatures.pear(), 50, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pearBees(), 1);
        LOTRBiomeFeatures.addGrass(this, 6);
        LOTRBiomeFeatures.addDoubleGrass(this, 1);
        LOTRBiomeFeatures.addPlainsFlowers(this, 2, new Object[0]);
        LOTRBiomeFeatures.addAthelasChance(this);
        LOTRBiomeFeatures.addWildPipeweedChance(this, 24);
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.ANFALAS;
    }
}

