/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class AngmarBiome
extends LOTRBiomeBase {
    public AngmarBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.2f).func_205420_b(0.6f).func_205414_c(0.2f).func_205417_d(0.3f), major);
    }

    protected AngmarBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setGrass(7896151).setSky(5654333).setClouds(0x3A3A3A).setFog(0x3A3A3A);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.4, 0.07) > 0.25) {
                return Blocks.field_150348_b.func_176223_P();
            }
            return in;
        });
    }

    @Override
    protected void addStoneVariants() {
        LOTRBiomeFeatures.addCommonGranite(this);
    }

    @Override
    protected void addOres() {
        super.addOres();
        LOTRBiomeFeatures.addStoneOrcishOres(this);
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 2, 6, 1);
    }

    @Override
    protected void addVegetation() {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.spruceThin(), 1000, LOTRBiomeFeatures.spruce(), 2000, LOTRBiomeFeatures.spruceDead(), 1000, LOTRBiomeFeatures.charred(), 1000, LOTRBiomeFeatures.fir(), 1000, LOTRBiomeFeatures.pine(), 2000};
        LOTRBiomeFeatures.addTrees(this, 0, 0.25f, weightedTrees);
        LOTRBiomeFeatures.addTreesAboveTreeline(this, 4, 0.1f, 80, weightedTrees);
        LOTRBiomeFeatures.addGrassWithoutPrettyTypes(this, 4);
        LOTRBiomeFeatures.addDoubleGrassWithoutPrettyTypes(this, 1);
    }

    @Override
    protected void addAnimals() {
        this.addWolves(2);
        this.addBears(1);
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, ((Block)LOTRBlocks.ANGMAR_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.ANGMAR_BRICK.get()).func_176223_P(), 4).func_227407_a_(((Block)LOTRBlocks.MOSSY_ANGMAR_BRICK.get()).func_176223_P(), 1).func_227407_a_(((Block)LOTRBlocks.CRACKED_ANGMAR_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.CRACKED_STONE_BRICK_WALL.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.ORC_TORCH.get()).func_176223_P(), 1));
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.ANGMAR;
    }

    public static class Mountains
    extends AngmarBiome {
        public Mountains(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(1.6f).func_205420_b(1.5f).func_205414_c(0.25f).func_205417_d(0.3f), major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setMountainTerrain((x, z, y, in, stone, top, rockDepth) -> {
                int snowLine = 130 - rockDepth;
                int stoneLine = snowLine - 20;
                if (top && y >= snowLine) {
                    return Blocks.field_196604_cC.func_176223_P();
                }
                if (y >= stoneLine && in.func_177230_c() != stone.func_177230_c()) {
                    return Blocks.field_150348_b.func_176223_P();
                }
                return in;
            });
        }

        @Override
        protected void addStoneVariants() {
            super.addStoneVariants();
            LOTRBiomeFeatures.addDeepDiorite(this);
        }

        @Override
        protected void addAnimals() {
        }
    }
}

