/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.ExtendedWeatherType;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public abstract class BaseMordorBiome
extends LOTRBiomeBase {
    protected BaseMordorBiome(Biome.Builder builder, int water, boolean major) {
        super(builder, water, major);
        this.biomeColors.setWater(water);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setFillerDepth(2.0);
        config.addSubSoilLayer(((Block)LOTRBlocks.MORDOR_DIRT.get()).func_176223_P(), 3);
        config.setUnderwater(((Block)LOTRBlocks.MORDOR_GRAVEL.get()).func_176223_P());
        config.addSubSoilLayer(((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 1000);
    }

    @Override
    protected void addDirtGravel() {
        LOTRBiomeFeatures.addMordorDirtGravel(this);
    }

    @Override
    protected void addStoneVariants() {
    }

    @Override
    protected void addOres() {
        LOTRBiomeFeatures.addMordorOres(this);
    }

    @Override
    protected void addReeds() {
        LOTRBiomeFeatures.addReedsWithDriedChance(this, 1.0f);
    }

    @Override
    protected void addPumpkins() {
    }

    @Override
    protected void addAnimals() {
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, ((Block)LOTRBlocks.MORDOR_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.MORDOR_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.MORDOR_BRICK_WALL.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.ORC_TORCH.get()).func_176223_P(), 1));
    }

    @Override
    public boolean hasSkyFeatures() {
        return false;
    }

    @Override
    protected ExtendedWeatherType getExtendedWeather() {
        return ExtendedWeatherType.ASHFALL;
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.MORDOR;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.MORDOR_PATH;
    }
}

