/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class BlueMountainsBiome
extends LOTRBiomeBase {
    public BlueMountainsBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(1.0f).func_205420_b(2.2f).func_205414_c(0.22f).func_205417_d(0.8f), major);
    }

    protected BlueMountainsBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setSky(7506425);
    }

    protected boolean isFoothills() {
        return false;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        if (!this.isFoothills()) {
            config.setMountainTerrain((x, z, y, in, stone, top, rockDepth) -> {
                int snowLine = 110 - rockDepth;
                int stoneLine = snowLine - 20;
                if (top && y >= snowLine) {
                    return Blocks.field_196604_cC.func_176223_P();
                }
                if (y >= stoneLine && in.func_177230_c() != stone.func_177230_c()) {
                    return ((Block)LOTRBlocks.BLUE_ROCK.get()).func_176223_P();
                }
                return in;
            });
        }
    }

    @Override
    protected void addStoneVariants() {
        LOTRBiomeFeatures.addAndesite(this);
        LOTRBiomeFeatures.addDeepDiorite(this);
        LOTRBiomeFeatures.addBlueRockPatches(this);
    }

    @Override
    protected void addOres() {
        super.addOres();
        LOTRBiomeFeatures.addExtraCoal(this, 8, 10, 128);
        LOTRBiomeFeatures.addExtraIron(this, 4, 10, 96);
        LOTRBiomeFeatures.addGlowstoneOre(this);
    }

    @Override
    protected void addCobwebs() {
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.4f, TreeCluster.of(10, 12), LOTRBiomeFeatures.oak(), 3000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.spruce(), 5000, LOTRBiomeFeatures.birch(), 4000, LOTRBiomeFeatures.pine(), 5000, LOTRBiomeFeatures.fir(), 5000);
        LOTRBiomeFeatures.addGrassWithoutPrettyTypes(this, 6);
        LOTRBiomeFeatures.addDoubleGrassWithoutPrettyTypes(this, 1);
        LOTRBiomeFeatures.addMountainsFlowers(this, 1, LOTRBlocks.DWARFWORT.get(), 1);
    }

    @Override
    protected void addLiquidSprings() {
        if (!this.isFoothills()) {
            LOTRBiomeFeatures.addWaterLavaSpringsReducedAboveground(this, 80, 0.15f);
        } else {
            super.addLiquidSprings();
        }
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, ((Block)LOTRBlocks.BLUE_MOUNTAINS_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.BLUE_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.BLUE_BRICK_WALL.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_222432_lU.func_176223_P(), 1));
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.BLUE_MOUNTAINS;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.DWARVEN;
    }

    public static class Foothills
    extends BlueMountainsBiome {
        public Foothills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(0.5f).func_205420_b(0.9f).func_205414_c(0.5f).func_205417_d(0.8f), major);
        }

        @Override
        protected boolean isFoothills() {
            return true;
        }
    }
}

