/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;

public class DeadMarshesBiome
extends LOTRBiomeBase {
    private static final int DEAD_MARSHES_WATER_COLOR = 4014639;

    public DeadMarshesBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(-0.24f).func_205420_b(0.0f).func_205414_c(0.4f).func_205417_d(1.0f), 4014639, major);
        this.biomeColors.setGrass(8024152).setFoliage(7041093).setSky(8684390).setClouds(7368024).setFog(6315334).setWater(4014639);
    }

    @Override
    public float getStrengthOfAddedDepthNoise() {
        return 0.15f;
    }

    @Override
    public float getBiomeScaleSignificanceForChunkGen() {
        return 1.0f;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setMarsh(true);
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.4, 0.07) > 0.15) {
                return top ? Blocks.field_196660_k.func_176223_P() : in;
            }
            return in;
        });
    }

    @Override
    protected void addBiomeSandSediments() {
        LOTRBiomeFeatures.addQuagmire(this, 1);
    }

    @Override
    protected void addVegetation() {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oakDead(), 1000};
        LOTRBiomeFeatures.addTrees(this, 0, 0.25f, weightedTrees);
        LOTRBiomeFeatures.addGrassWithFernsWithoutPrettyTypes(this, 6);
        LOTRBiomeFeatures.addDoubleGrassWithFernsWithoutPrettyTypes(this, 4);
        LOTRBiomeFeatures.addSwampFlowers(this, 0, new Object[0]);
        LOTRBiomeFeatures.addDeadBushAtSurfaceChance(this, 1);
        LOTRBiomeFeatures.addMoreMushroomsFreq(this, 3);
        LOTRBiomeFeatures.addSwampSeagrass(this);
    }

    @Override
    protected void addReeds() {
        LOTRBiomeFeatures.addReedsWithDriedChance(this, 1.0f);
        LOTRBiomeFeatures.addSwampRushes(this);
    }

    @Override
    protected void addPumpkins() {
    }

    @Override
    protected void addAnimals() {
    }

    @Override
    public LOTRBiomeBase getRiver() {
        return null;
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.NINDALF;
    }
}

