/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class DorEnErnilBiome
extends LOTRBiomeBase {
    public DorEnErnilBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.04f).func_205420_b(0.28f).func_205414_c(0.9f).func_205417_d(0.9f), major);
    }

    protected DorEnErnilBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.addSubSoilLayer(((Block)LOTRBlocks.GONDOR_ROCK.get()).func_176223_P(), 8, 10);
    }

    @Override
    protected void addStoneVariants() {
        LOTRBiomeFeatures.addGranite(this);
        LOTRBiomeFeatures.addGondorRockPatches(this);
    }

    @Override
    protected void addBiomeSandSediments() {
        LOTRBiomeFeatures.addWhiteSandSediments(this);
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, ((Block)LOTRBlocks.GONDOR_ROCK.get()).func_176223_P(), 1, 2, 200, 3);
    }

    protected final Object[] dorEnErnilTrees() {
        return new Object[]{LOTRBiomeFeatures.birch(), 2000, LOTRBiomeFeatures.birchFancy(), 2000, LOTRBiomeFeatures.birchBees(), 20, LOTRBiomeFeatures.birchFancyBees(), 20, LOTRBiomeFeatures.oak(), 800, LOTRBiomeFeatures.oakTall(), 800, LOTRBiomeFeatures.oakFancy(), 800, LOTRBiomeFeatures.oakBees(), 8, LOTRBiomeFeatures.oakTallBees(), 8, LOTRBiomeFeatures.oakFancyBees(), 8, LOTRBiomeFeatures.cedar(), 1000, LOTRBiomeFeatures.cypress(), 500, LOTRBiomeFeatures.apple(), 50, LOTRBiomeFeatures.pear(), 50, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pearBees(), 1};
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.03f, TreeCluster.of(10, 30), this.dorEnErnilTrees());
        LOTRBiomeFeatures.addGrass(this, 8);
        LOTRBiomeFeatures.addDoubleGrass(this, 4);
        LOTRBiomeFeatures.addPlainsFlowers(this, 4, new Object[0]);
        LOTRBiomeFeatures.addAthelasChance(this);
        LOTRBiomeFeatures.addWildPipeweedChance(this, 24);
    }

    @Override
    protected void addReeds() {
        super.addReeds();
        LOTRBiomeFeatures.addSugarCane(this);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.addHorsesDonkeys(6);
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, ((Block)LOTRBlocks.DOL_AMROTH_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.DOL_AMROTH_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.DOL_AMROTH_BRICK_WALL.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_222432_lU.func_176223_P(), 1));
    }

    @Override
    public LOTRBiomeBase getShore() {
        return (LOTRBiomeBase)LOTRBiomes.WHITE_BEACH.get();
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.DOR_EN_ERNIL;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.DOL_AMROTH;
    }

    public static class Hills
    extends DorEnErnilBiome {
        public Hills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.7f).func_205420_b(0.7f).func_205414_c(0.7f).func_205417_d(0.9f), major);
        }

        @Override
        protected void addStoneVariants() {
            super.addStoneVariants();
            LOTRBiomeFeatures.addDiorite(this);
        }

        @Override
        protected void addVegetation() {
            LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.65f, TreeCluster.of(10, 10), this.dorEnErnilTrees());
            LOTRBiomeFeatures.addGrass(this, 5);
            LOTRBiomeFeatures.addDoubleGrass(this, 1);
            LOTRBiomeFeatures.addPlainsFlowers(this, 2, new Object[0]);
            LOTRBiomeFeatures.addAthelasChance(this);
            LOTRBiomeFeatures.addWildPipeweedChance(this, 24);
        }

        @Override
        public LOTRBiomeBase getRiver() {
            return null;
        }
    }
}

