/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.util.LOTRUtil;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class EriadorBiome
extends LOTRBiomeBase {
    public EriadorBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.1f).func_205420_b(0.4f).func_205414_c(0.8f).func_205417_d(0.8f), major);
    }

    protected EriadorBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
    }

    @Override
    protected void addStoneVariants() {
        LOTRBiomeFeatures.addCommonGranite(this);
    }

    protected final Object[] eriadorTrees() {
        return new Object[]{LOTRBiomeFeatures.oak(), 10000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakBees(), 10, LOTRBiomeFeatures.oakFancyBees(), 1, LOTRBiomeFeatures.birch(), 1000, LOTRBiomeFeatures.birchFancy(), 100, LOTRBiomeFeatures.birchBees(), 1, LOTRBiomeFeatures.birchFancyBees(), 1, LOTRBiomeFeatures.spruce(), 2000, LOTRBiomeFeatures.beech(), 200, LOTRBiomeFeatures.beechFancy(), 20, LOTRBiomeFeatures.beechBees(), 1, LOTRBiomeFeatures.beechFancyBees(), 1, LOTRBiomeFeatures.maple(), 50, LOTRBiomeFeatures.mapleFancy(), 5, LOTRBiomeFeatures.mapleBees(), 1, LOTRBiomeFeatures.mapleFancyBees(), 1, LOTRBiomeFeatures.aspen(), 500, LOTRBiomeFeatures.aspenLarge(), 50, LOTRBiomeFeatures.apple(), 20, LOTRBiomeFeatures.pear(), 20, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pearBees(), 1};
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.08f, TreeCluster.of(8, 12), this.eriadorTrees());
        LOTRBiomeFeatures.addGrass(this, 9);
        LOTRBiomeFeatures.addDoubleGrass(this, 4);
        LOTRBiomeFeatures.addPlainsFlowers(this, 2, LOTRBlocks.LAVENDER.get(), 20);
        LOTRBiomeFeatures.addAthelasChance(this);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.addHorsesDonkeys();
        this.addBears(2);
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, 2, ((Block)LOTRBlocks.RANGER_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.ARNOR_BRICK.get()).func_176223_P(), 4).func_227407_a_(((Block)LOTRBlocks.MOSSY_ARNOR_BRICK.get()).func_176223_P(), 1).func_227407_a_(((Block)LOTRBlocks.CRACKED_ARNOR_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_180407_aO.func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_150478_aa.func_176223_P(), 1));
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.ERIADOR;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.ARNOR.withRepair(0.9f);
    }

    public static class ErynVorn
    extends EriadorBiome {
        public ErynVorn(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.1f).func_205420_b(0.4f).func_205414_c(0.8f).func_205417_d(0.9f), major);
        }

        @Override
        protected void addVegetation() {
            Object[] weightedTrees = LOTRUtil.combineVarargs(this.eriadorTrees(), LOTRBiomeFeatures.pine(), 10000, LOTRBiomeFeatures.fir(), 3000, LOTRBiomeFeatures.spruce(), 1000);
            LOTRBiomeFeatures.addTrees(this, 10, 0.0f, weightedTrees);
            LOTRBiomeFeatures.addGrassWithFerns(this, 9);
            LOTRBiomeFeatures.addDoubleGrassWithFerns(this, 2);
            LOTRBiomeFeatures.addForestFlowers(this, 4, new Object[0]);
            LOTRBiomeFeatures.addDefaultDoubleFlowers(this, 1, new Object[0]);
            LOTRBiomeFeatures.addAthelasChance(this);
            LOTRBiomeFeatures.addFoxBerryBushes(this);
        }

        @Override
        protected void addAnimals() {
            super.addAnimals();
            this.addWolves();
            this.addBears();
            this.addFoxes();
        }
    }

    public static class Minhiriath
    extends EriadorBiome {
        public Minhiriath(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.1f).func_205420_b(0.3f).func_205414_c(0.7f).func_205417_d(0.5f), major);
        }

        @Override
        protected void addBoulders() {
            super.addBoulders();
            LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 3, 32, 3);
        }

        @Override
        protected void addVegetation() {
            Object[] weightedTrees = LOTRUtil.combineVarargs(this.eriadorTrees(), LOTRBiomeFeatures.oakDead(), 20000, LOTRBiomeFeatures.spruceDead(), 6000, LOTRBiomeFeatures.beechDead(), 2000, LOTRBiomeFeatures.birchDead(), 1000);
            LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.06f, TreeCluster.of(8, 30), weightedTrees);
            LOTRBiomeFeatures.addGrass(this, 5);
            LOTRBiomeFeatures.addDoubleGrass(this, 3);
            LOTRBiomeFeatures.addPlainsFlowers(this, 2, LOTRBlocks.LAVENDER.get(), 20);
            LOTRBiomeFeatures.addAthelasChance(this);
        }

        @Override
        protected void addAnimals() {
            super.addAnimals();
        }
    }

    public static class Downs
    extends EriadorBiome {
        public Downs(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.7f).func_205420_b(0.6f).func_205414_c(0.6f).func_205417_d(0.7f), major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setFillerDepth(0.0);
            config.addSubSoilLayer(((Block)LOTRBlocks.DIRTY_CHALK.get()).func_176223_P(), 1);
            config.addSubSoilLayer(((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 3);
        }

        @Override
        protected void addStoneVariants() {
            super.addStoneVariants();
            LOTRBiomeFeatures.addDiorite(this);
        }

        @Override
        protected void addBoulders() {
            super.addBoulders();
            LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 4, 40, 3);
            LOTRBiomeFeatures.addBoulders(this, ((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 1, 1, 16, 3);
            LOTRBiomeFeatures.addBoulders(this, ((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 2, 3, 40, 1);
        }

        @Override
        protected void addVegetation() {
            LOTRBiomeFeatures.addTrees(this, 0, 0.03f, this.eriadorTrees());
            LOTRBiomeFeatures.addMoorsGrass(this, 5);
            LOTRBiomeFeatures.addMoorsDoubleGrass(this, 1);
            LOTRBiomeFeatures.addPlainsFlowers(this, 2, new Object[0]);
            LOTRBiomeFeatures.addAthelasChance(this);
        }
    }
}

