/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.util.LOTRUtil;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.IProperty;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class EttenmoorsBiome
extends LOTRBiomeBase {
    public EttenmoorsBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(0.5f).func_205420_b(0.7f).func_205414_c(0.2f).func_205417_d(0.6f), major);
        this.biomeColors.setGrass(11910259);
        this.biomeColors.setSky(12965352);
    }

    @Override
    protected void addStoneVariants() {
        LOTRBiomeFeatures.addCommonGranite(this);
    }

    @Override
    protected void addOres() {
        super.addOres();
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 2, 3, 2);
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 2, 5, 12, 3);
    }

    @Override
    protected void addVegetation() {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.fir(), 400, LOTRBiomeFeatures.pine(), 800, LOTRBiomeFeatures.spruce(), 500, LOTRBiomeFeatures.spruceThin(), 500};
        Object[] weightedTreesWithDead = LOTRUtil.combineVarargs(weightedTrees, LOTRBiomeFeatures.spruceDead(), 3000);
        LOTRBiomeFeatures.addTrees(this, 0, 0.05f, weightedTreesWithDead);
        LOTRBiomeFeatures.addTreesAboveTreeline(this, 2, 0.5f, 87, weightedTrees);
        LOTRBiomeFeatures.addMoorsGrass(this, 4);
        LOTRBiomeFeatures.addBorealFlowers(this, 1, new Object[0]);
        LOTRBiomeFeatures.addAthelasChance(this);
        LOTRBiomeFeatures.addTundraBushes(this, 3, 40, (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_((BlockState)Blocks.field_196645_X.func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), 3).func_227407_a_((BlockState)((Block)LOTRBlocks.FIR_LEAVES.get()).func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), 3).func_227407_a_((BlockState)((Block)LOTRBlocks.PINE_LEAVES.get()).func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), 3));
    }

    @Override
    protected void addAnimals() {
        this.addWolves(2);
        this.addElk(1);
        this.addBears(1);
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.ETTENMOORS;
    }
}

