/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.block.DripstoneBlock;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class ForochelBiome
extends LOTRBiomeBase {
    public ForochelBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.ICY).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.1f).func_205417_d(0.3f), major);
        this.biomeColors.setSky(11783899).setGrass(12235394);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.3, 0.06) > 0.3) {
                return top ? Blocks.field_196660_k.func_176223_P() : in;
            }
            if (config.getNoise2(x, z, 0.3, 0.02) > 0.25) {
                return top ? Blocks.field_196604_cC.func_176223_P() : in;
            }
            return in;
        });
    }

    @Override
    protected void addStoneVariants() {
        super.addStoneVariants();
        LOTRBiomeFeatures.addPackedIceVeins(this, 40);
    }

    @Override
    protected void addDripstones() {
        super.addDripstones();
        LOTRBiomeFeatures.addDripstones(this, (DripstoneBlock)LOTRBlocks.ICE_DRIPSTONE.get(), 2);
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 3, 80, 1);
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 3, 80, 3);
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.04f, TreeCluster.of(8, 100), LOTRBiomeFeatures.spruce(), 600, LOTRBiomeFeatures.spruceThin(), 400, LOTRBiomeFeatures.spruceDead(), 2500, LOTRBiomeFeatures.pine(), 400, LOTRBiomeFeatures.fir(), 1000);
        LOTRBiomeFeatures.addGrassWithoutPrettyTypes(this, 1);
        LOTRBiomeFeatures.addBorealFlowers(this, 2, new Object[0]);
    }

    @Override
    protected void addAnimals() {
        this.addWolves(1);
        this.addDeer(1);
        this.addElk(2);
        this.addBears(2);
        this.addFoxes(2);
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200786_Z, 1, 1, 2));
    }

    public boolean func_201850_b(IWorldReader world, BlockPos pos) {
        return super.func_201850_b(world, pos) && this.isForochelSnowy(world, pos);
    }

    private boolean isForochelSnowy(IWorldReader world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196604_cC) {
            return true;
        }
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        double d1 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.002, (double)z * 0.002, false);
        double d2 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.05, (double)z * 0.05, false);
        double d3 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.3, (double)z * 0.3, false);
        return d1 + (d2 *= 0.3) + (d3 *= 0.3) > 0.6;
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, ((Block)LOTRBlocks.LOSSOTH_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.SNOW_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.LARCH_FENCE.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.BLUBBER_TORCH.get()).func_176223_P(), 1));
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.FOROCHEL;
    }
}

