/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.block.DripstoneBlock;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;

public class ForodwaithBiome
extends LOTRBiomeBase {
    public ForodwaithBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.ICY).func_205421_a(0.1f).func_205420_b(0.1f).func_205414_c(0.0f).func_205417_d(0.2f), major);
    }

    protected ForodwaithBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setSky(10069160);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setTop(Blocks.field_196604_cC.func_176223_P());
    }

    @Override
    protected void addStoneVariants() {
        super.addStoneVariants();
        LOTRBiomeFeatures.addPackedIceVeins(this, 40);
    }

    @Override
    protected void addDripstones() {
        super.addDripstones();
        LOTRBiomeFeatures.addDripstones(this, (DripstoneBlock)LOTRBlocks.ICE_DRIPSTONE.get(), 2);
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 2, 80, 2);
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 2, 80, 5);
    }

    @Override
    protected void addVegetation() {
    }

    @Override
    protected void addLiquidSprings() {
        LOTRBiomeFeatures.addLavaSprings(this);
    }

    @Override
    protected void addAnimals() {
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200786_Z, 1, 1, 2));
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.FORODWAITH;
    }

    public static class Mountains
    extends ForodwaithBiome {
        public Mountains(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.ICY).func_205421_a(2.0f).func_205420_b(2.0f).func_205414_c(0.0f).func_205417_d(0.2f), major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setMountainTerrain((x, z, y, in, stone, top, rockDepth) -> {
                int snowLine = 100 - rockDepth;
                int stoneLine = snowLine - 30;
                if (top && y >= snowLine) {
                    return Blocks.field_196604_cC.func_176223_P();
                }
                if (y >= stoneLine && in.func_177230_c() != stone.func_177230_c()) {
                    return Blocks.field_150348_b.func_176223_P();
                }
                return in;
            });
        }
    }
}

