/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.BaseMordorBiome;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;

public class GorgorothBiome
extends BaseMordorBiome {
    private static final int GORGOROTH_WATER_COLOR = 2498845;

    public GorgorothBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.DESERT).func_205421_a(0.7f).func_205420_b(0.4f).func_205414_c(1.5f).func_205417_d(0.0f), 2498845, major);
        this.biomeColors.setGrass(5980459).setFoliage(5987138).setSky(0x663E33).setClouds(4924185).setFog(3154711);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        super.setupSurface(config);
        config.setTop(((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P());
        config.setFiller(((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P());
        config.resetFillerDepthAndSubSoilLayers();
        config.addSubSoilLayer(((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 1000);
        config.setRockyTerrain(false);
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.4, 0.08) > 0.25) {
                return ((Block)LOTRBlocks.MORDOR_DIRT.get()).func_176223_P();
            }
            if (config.getNoise2(x, z, 0.4, 0.08) > 0.4) {
                return ((Block)LOTRBlocks.MORDOR_GRAVEL.get()).func_176223_P();
            }
            return in;
        });
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, ((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 2, 6, 30, 4);
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesIncrease(this, 0, 0.0125f, 7, LOTRBiomeFeatures.charred(), 1);
        LOTRBiomeFeatures.addMordorMoss(this, 20);
        LOTRBiomeFeatures.addMordorGrass(this, 2);
        LOTRBiomeFeatures.addMordorThorns(this, 40);
        LOTRBiomeFeatures.addMorgulShrooms(this, 32);
    }

    @Override
    protected void addLiquidSprings() {
        LOTRBiomeFeatures.addWaterSprings(this);
        LOTRBiomeFeatures.addLavaSprings(this, 50);
    }
}

