/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;

public class GreyMountainsBiome
extends LOTRBiomeBase {
    public GreyMountainsBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(1.8f).func_205420_b(2.0f).func_205414_c(0.28f).func_205417_d(0.3f), major);
    }

    protected GreyMountainsBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setSky(10862798);
    }

    protected boolean isFoothills() {
        return false;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        if (!this.isFoothills()) {
            config.setMountainTerrain((x, z, y, in, stone, top, rockDepth) -> {
                int snowLine = 150 - rockDepth;
                int stoneLine = snowLine - 40;
                if (top && y >= snowLine) {
                    return Blocks.field_196604_cC.func_176223_P();
                }
                if (y >= stoneLine && in.func_177230_c() != stone.func_177230_c()) {
                    return Blocks.field_150348_b.func_176223_P();
                }
                return in;
            });
        }
    }

    @Override
    protected void addStoneVariants() {
        super.addStoneVariants();
        LOTRBiomeFeatures.addDeepDiorite(this);
    }

    @Override
    protected void addOres() {
        super.addOres();
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesBelowTreeline(this, 3, 0.1f, 100, LOTRBiomeFeatures.spruce(), 4000, LOTRBiomeFeatures.spruceThin(), 4000, LOTRBiomeFeatures.spruceMega(), 500, LOTRBiomeFeatures.spruceThinMega(), 100, LOTRBiomeFeatures.larch(), 5000, LOTRBiomeFeatures.fir(), 5000, LOTRBiomeFeatures.pine(), 5000);
        LOTRBiomeFeatures.addGrassWithoutPrettyTypes(this, 2);
        LOTRBiomeFeatures.addDoubleGrassWithoutPrettyTypes(this, 1);
        LOTRBiomeFeatures.addMountainsFlowers(this, 1, new Object[0]);
    }

    @Override
    protected void addLiquidSprings() {
        if (!this.isFoothills()) {
            LOTRBiomeFeatures.addWaterLavaSpringsReducedAboveground(this, 80, 0.15f);
        } else {
            super.addLiquidSprings();
        }
    }

    @Override
    protected void addAnimals() {
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.GREY_MOUNTAINS;
    }

    public static class Foothills
    extends GreyMountainsBiome {
        public Foothills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(0.5f).func_205420_b(0.9f).func_205414_c(0.5f).func_205417_d(0.7f), major);
        }

        @Override
        protected boolean isFoothills() {
            return true;
        }
    }
}

