/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.ExtendedWeatherType;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;

public class HaradDesertBiome
extends LOTRBiomeBase {
    public HaradDesertBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.DESERT).func_205421_a(0.2f).func_205420_b(0.1f).func_205414_c(1.5f).func_205417_d(0.1f), major);
    }

    protected HaradDesertBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setCloudCoverage(0.2f);
        this.biomeColors.setFog(16180681);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setTop(Blocks.field_150354_m.func_176223_P());
        config.setFiller(Blocks.field_150354_m.func_176223_P());
    }

    @Override
    protected void addOres() {
        super.addOres();
        LOTRBiomeFeatures.addLapisOre(this);
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 3, 240, 3);
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150322_A.func_176223_P(), 1, 3, 240, 3);
    }

    @Override
    protected void addVegetation() {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oakDead(), 8000, LOTRBiomeFeatures.oakDesert(), 2000};
        LOTRBiomeFeatures.addTreesIncrease(this, 0, 5.0E-4f, 1, weightedTrees);
        LOTRBiomeFeatures.addTreesIncrease(this, 0, 5.0E-4f, 3, weightedTrees);
        LOTRBiomeFeatures.addGrassWithArid(this, 1);
        LOTRBiomeFeatures.addHaradFlowers(this, 0, new Object[0]);
        LOTRBiomeFeatures.addCactiAtSurfaceChance(this, 50);
        LOTRBiomeFeatures.addDeadBushAtSurfaceChance(this, 16);
    }

    @Override
    protected void addReeds() {
        LOTRBiomeFeatures.addLessCommonReeds(this);
        LOTRBiomeFeatures.addMoreCommonPapyrus(this);
    }

    @Override
    protected void addAnimals() {
    }

    @Override
    protected ExtendedWeatherType getExtendedWeather() {
        return ExtendedWeatherType.SANDSTORM;
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.HARAD_DESERT;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.HARAD.withRepair(0.5f);
    }

    public static class Hills
    extends HaradDesertBiome {
        public Hills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.DESERT).func_205421_a(0.5f).func_205420_b(0.8f).func_205414_c(1.2f).func_205417_d(0.3f), major);
            this.biomeColors.setCloudCoverage(0.4f);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
                if (config.getNoise1(x, z, 0.4, 0.09) > 0.1) {
                    return Blocks.field_150322_A.func_176223_P();
                }
                if (config.getNoise2(x, z, 0.4, 0.09) > 0.3) {
                    return Blocks.field_150348_b.func_176223_P();
                }
                return in;
            });
        }

        @Override
        protected void addVegetation() {
            Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oakDead(), 8000, LOTRBiomeFeatures.oakDesert(), 2000};
            LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.01f, TreeCluster.of(6, 100), weightedTrees);
            LOTRBiomeFeatures.addGrassWithArid(this, 1);
            LOTRBiomeFeatures.addHaradFlowers(this, 0, new Object[0]);
            LOTRBiomeFeatures.addCactiAtSurfaceChance(this, 200);
            LOTRBiomeFeatures.addDeadBushAtSurfaceChance(this, 16);
        }
    }

    public static class HalfDesert
    extends HaradDesertBiome {
        public HalfDesert(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.DESERT).func_205421_a(0.2f).func_205420_b(0.1f).func_205414_c(1.5f).func_205417_d(0.3f), major);
            this.biomeColors.setCloudCoverage(0.6f);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
                if (config.getNoise1(x, z, 0.3, 0.08) > 0.15) {
                    return top ? Blocks.field_196660_k.func_176223_P() : in;
                }
                return in;
            });
        }

        @Override
        protected void addVegetation() {
            Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oakDead(), 5000, LOTRBiomeFeatures.oakDesert(), 5000};
            LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.05f, TreeCluster.of(8, 100), weightedTrees);
            LOTRBiomeFeatures.addGrassWithArid(this, 5);
            LOTRBiomeFeatures.addDoubleGrassWithArid(this, 1);
            LOTRBiomeFeatures.addHaradFlowers(this, 0, new Object[0]);
            LOTRBiomeFeatures.addCactiAtSurfaceChance(this, 200);
            LOTRBiomeFeatures.addDeadBushAtSurfaceChance(this, 16);
        }
    }
}

