/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class HarnennorBiome
extends LOTRBiomeBase {
    public HarnennorBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.1f).func_205420_b(0.3f).func_205414_c(1.0f).func_205417_d(0.3f), major);
        this.biomeColors.setGrass(0xDDD566);
        this.biomeColors.setFog(16248281);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.4, 0.09) > 0.1) {
                return top ? Blocks.field_196660_k.func_176223_P() : in;
            }
            if (config.getNoise2(x, z, 0.4, 0.09) > 0.3) {
                return Blocks.field_150354_m.func_176223_P();
            }
            return in;
        });
    }

    @Override
    protected void addOres() {
        super.addOres();
        LOTRBiomeFeatures.addLapisOre(this);
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 2, 12, 3);
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.1f, TreeCluster.of(3, 30), LOTRBiomeFeatures.oakDesert(), 10000, LOTRBiomeFeatures.oakDesertBees(), 100, LOTRBiomeFeatures.cedar(), 2500);
        LOTRBiomeFeatures.addGrassWithArid(this, 8);
        LOTRBiomeFeatures.addDoubleGrassWithArid(this, 1);
        LOTRBiomeFeatures.addDeadBushes(this, 1);
        LOTRBiomeFeatures.addHaradFlowers(this, 3, new Object[0]);
        LOTRBiomeFeatures.addCactiFreq(this, 1);
    }

    @Override
    protected void addReeds() {
        LOTRBiomeFeatures.addLessCommonReeds(this);
        LOTRBiomeFeatures.addPapyrus(this);
        LOTRBiomeFeatures.addSugarCane(this);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.addHorsesDonkeys(2);
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, ((Block)LOTRBlocks.HARAD_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.HARAD_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.CEDAR_FENCE.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.BRONZE_LANTERN.get()).func_176223_P(), 1));
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.HARNENNOR;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.HARAD_PATH;
    }
}

