/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;

public class HarondorBiome
extends LOTRBiomeBase {
    public HarondorBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.2f).func_205420_b(0.3f).func_205414_c(1.0f).func_205417_d(0.6f), major);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.4, 0.09) > 0.15) {
                return top ? Blocks.field_196660_k.func_176223_P() : in;
            }
            if (config.getNoise2(x, z, 0.002) + config.getNoise2(x, z, 0.4, 0.09) > 0.7) {
                return Blocks.field_150354_m.func_176223_P();
            }
            return in;
        });
    }

    @Override
    protected void addOres() {
        super.addOres();
        LOTRBiomeFeatures.addLapisOre(this);
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 3, 16, 4);
    }

    @Override
    protected void addVegetation() {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oakDesert(), 10000, LOTRBiomeFeatures.oakDesertBees(), 10, LOTRBiomeFeatures.cedar(), 2500};
        LOTRBiomeFeatures.addTrees(this, 0, 0.1f, weightedTrees);
        LOTRBiomeFeatures.addTreesIncrease(this, 0, 0.0625f, 3, weightedTrees);
        LOTRBiomeFeatures.addTreesIncrease(this, 0, 0.0625f, 7, weightedTrees);
        LOTRBiomeFeatures.addGrassWithArid(this, 8);
        LOTRBiomeFeatures.addDoubleGrassWithArid(this, 1);
        LOTRBiomeFeatures.addDeadBushes(this, 1);
        LOTRBiomeFeatures.addPlainsFlowers(this, 4, new Object[0]);
        LOTRBiomeFeatures.addCactiFreq(this, 1);
    }

    @Override
    protected void addReeds() {
        super.addReeds();
        LOTRBiomeFeatures.addSugarCane(this);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.HARONDOR;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.GONDOR.withRepair(0.6f);
    }
}

