/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class IronHillsBiome
extends LOTRBiomeBase {
    public IronHillsBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(0.3f).func_205420_b(1.4f).func_205414_c(0.27f).func_205417_d(0.4f), major);
    }

    @Override
    protected void addStoneVariants() {
    }

    @Override
    protected void addOres() {
        super.addOres();
        LOTRBiomeFeatures.addExtraIron(this, 4, 20, 96);
        LOTRBiomeFeatures.addExtraGold(this, 4, 2, 48);
        LOTRBiomeFeatures.addExtraSilver(this, 4, 2, 48);
        LOTRBiomeFeatures.addGlowstoneOre(this);
    }

    @Override
    protected void addCobwebs() {
    }

    @Override
    protected void addVegetation() {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.spruce(), 5000, LOTRBiomeFeatures.spruceMega(), 2000, LOTRBiomeFeatures.spruceThinMega(), 500, LOTRBiomeFeatures.pine(), 4000, LOTRBiomeFeatures.fir(), 4000};
        LOTRBiomeFeatures.addTrees(this, 0, 0.1f, weightedTrees);
        LOTRBiomeFeatures.addTreesAboveTreeline(this, 8, 0.1f, 80, weightedTrees);
        LOTRBiomeFeatures.addGrass(this, 8);
        LOTRBiomeFeatures.addDoubleGrass(this, 1);
        LOTRBiomeFeatures.addMountainsFlowers(this, 1, LOTRBlocks.DWARFWORT.get(), 1);
    }

    @Override
    protected void addLiquidSprings() {
        LOTRBiomeFeatures.addWaterLavaSpringsReducedAboveground(this, 80, 0.15f);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.addWolves(1);
        this.addBears(2);
        this.addBoars(3);
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, ((Block)LOTRBlocks.DWARVEN_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.DWARVEN_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_180408_aP.func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_222432_lU.func_176223_P(), 1));
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.IRON_HILLS;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.DWARVEN;
    }
}

