/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.awt.Color;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRLog;
import lotr.common.LOTRMod;
import lotr.common.init.LOTRBiomes;
import lotr.common.util.CalendarUtil;
import lotr.common.world.biome.ExtendedWeatherType;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.gen.feature.WeightedRandomFeatureConfig;
import lotr.common.world.map.BridgeBlockProvider;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class LOTRBiomeBase
extends Biome {
    private int mapBiomeColor;
    public final boolean isMajorBiome;
    protected CustomBiomeColors biomeColors;
    protected static final int STANDARD_WATER_FOG_COLOR = 329011;
    protected static final PerlinNoiseGenerator SNOW_VARIETY_NOISE = new PerlinNoiseGenerator(new SharedSeedRandom(2490309256000602L), 0, 0);
    private float biomeTreeAmount;
    private WeightedRandomFeatureConfig grassBonemealGenerator;

    protected LOTRBiomeBase(Biome.Builder builder, int waterFogColor, boolean major) {
        super(builder.func_222351_a((SurfaceBuilder)LOTRBiomes.createMiddleEarthSurface(), (ISurfaceBuilderConfig)MiddleEarthSurfaceConfig.createDefault()).func_205412_a(0xFFFFFF).func_205413_b(waterFogColor).func_205418_a(null));
        this.setupSurface((MiddleEarthSurfaceConfig)this.func_203944_q());
        this.addFeatures();
        this.addAnimals();
        this.isMajorBiome = major;
        this.biomeColors = new CustomBiomeColors();
    }

    protected LOTRBiomeBase(Biome.Builder builder, boolean major) {
        this(builder, 329011, major);
    }

    public final int getRegistryIntID() {
        return LOTRBiomes.getBiomeID(this);
    }

    public double getHorizontalNoiseScale() {
        return 400.0;
    }

    public float getStrengthOfAddedDepthNoise() {
        return 1.0f;
    }

    public float getBiomeScaleSignificanceForChunkGen() {
        return 0.9f;
    }

    protected void setupSurface(MiddleEarthSurfaceConfig config) {
    }

    protected void addFeatures() {
        this.addCarvers();
        this.addLakes();
        this.addDirtGravel();
        this.addStoneVariants();
        this.addOres();
        this.addDripstones();
        this.addCobwebs();
        this.addSedimentDisks();
        this.addBoulders();
        this.addVegetation();
        LOTRBiomeFeatures.addMushrooms(this);
        this.addReeds();
        this.addPumpkins();
        this.addLiquidSprings();
        LOTRBiomeFeatures.addFreezeTopLayer(this);
        this.addStructures();
    }

    protected void addCarvers() {
        LOTRBiomeFeatures.addCarvers(this);
    }

    protected void addLakes() {
        LOTRBiomeFeatures.addLakes(this);
    }

    protected void addDirtGravel() {
        LOTRBiomeFeatures.addDirtGravel(this);
    }

    protected void addStoneVariants() {
        LOTRBiomeFeatures.addGranite(this);
    }

    protected void addOres() {
        LOTRBiomeFeatures.addOres(this);
    }

    protected void addDripstones() {
        LOTRBiomeFeatures.addDripstones(this);
    }

    protected void addCobwebs() {
        LOTRBiomeFeatures.addCobwebs(this);
    }

    protected void addSedimentDisks() {
        this.addBiomeSandSediments();
        LOTRBiomeFeatures.addClayGravelSediments(this);
    }

    protected void addBiomeSandSediments() {
        LOTRBiomeFeatures.addSandSediments(this);
    }

    protected void addBoulders() {
    }

    protected void addVegetation() {
    }

    public void setGrassBonemealGenerator(WeightedRandomFeatureConfig config) {
        this.grassBonemealGenerator = config;
    }

    public WeightedRandomFeatureConfig getGrassBonemealGenerator() {
        return this.grassBonemealGenerator;
    }

    public BlockState getGrassForBonemeal(Random rand, BlockPos pos) {
        if (this.grassBonemealGenerator != null) {
            ConfiguredFeature feature = this.grassBonemealGenerator.getRandomFeature(rand);
            if (feature.field_222738_b instanceof BlockClusterFeatureConfig) {
                return ((BlockClusterFeatureConfig)feature.field_222738_b).field_227289_a_.func_225574_a_(rand, pos);
            }
            LOTRLog.warn("DEVELOPMENT ERROR: Biome (%s) grass bonemeal generator contains a FeatureConfig of invalid type - should be BlockClusterFeatureConfig, but is %s", this.getRegistryName(), feature.field_222738_b.getClass().getName());
        }
        return Blocks.field_150349_c.func_176223_P();
    }

    protected void addReeds() {
        LOTRBiomeFeatures.addReeds(this);
    }

    protected void addPumpkins() {
        LOTRBiomeFeatures.addPumpkins(this);
    }

    protected void addLiquidSprings() {
        LOTRBiomeFeatures.addWaterLavaSprings(this);
    }

    public List<Biome.SpawnListEntry> getSpawnsAtLocation(EntityClassification creatureType, IWorld world, BlockPos pos) {
        return this.func_76747_a(creatureType);
    }

    protected void addAnimals() {
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200737_ac, 24, 4, 4));
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200784_X, 20, 4, 4));
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200795_i, 20, 4, 4));
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200796_j, 16, 4, 4));
        this.func_201866_a(EntityClassification.AMBIENT, new Biome.SpawnListEntry(EntityType.field_200791_e, 10, 8, 8));
        this.addDeer();
    }

    protected void addExtraSheep(int mul) {
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200737_ac, 24 * mul, 4, 4));
    }

    protected void addHorsesDonkeys() {
        this.addHorsesDonkeys(1);
    }

    protected void addHorsesDonkeys(int mul) {
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200762_B, 10 * mul, 2, 6));
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200798_l, 1 * mul, 1, 3));
    }

    protected void addWolves() {
        this.addWolves(1);
    }

    protected void addWolves(int mul) {
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200724_aC, 10 * mul, 4, 8));
    }

    protected void addFoxes() {
        this.addFoxes(1);
    }

    protected void addFoxes(int mul) {
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_220356_B, 16 * mul, 2, 4));
    }

    protected void addDeer() {
        this.addDeer(1);
    }

    protected void addDeer(int mul) {
    }

    protected void addBoars() {
        this.addBoars(1);
    }

    protected void addBoars(int mul) {
    }

    protected void addBears() {
        this.addBears(1);
    }

    protected void addBears(int mul) {
    }

    protected void addElk() {
        this.addElk(1);
    }

    protected void addElk(int mul) {
    }

    protected void addStructures() {
    }

    public final float getBiomeTreeAmount() {
        return this.biomeTreeAmount;
    }

    public final void updateBiomeTreeAmount(float f) {
        this.biomeTreeAmount = Math.max(this.biomeTreeAmount, f);
    }

    public LOTRBiomeBase setMapColor(int color) {
        if (LOTRBiomes.MAP_BIOME_COLORS.containsKey(color)) {
            throw new IllegalArgumentException(String.format("Cannot set LOTR biome %s map color to %s; biome %s already has that color!", this.getRegistryName(), Integer.toHexString(color), LOTRBiomes.MAP_BIOME_COLORS.get(color).getRegistryName()));
        }
        this.mapBiomeColor = color;
        LOTRBiomes.MAP_BIOME_COLORS.put(color, this);
        return this;
    }

    public final int getMapBiomeColor() {
        return this.mapBiomeColor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_225528_a_(double x, double z) {
        if (this.biomeColors.hasGrass()) {
            return this.biomeColors.getGrass();
        }
        return super.func_225528_a_(x, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_225527_a_() {
        if (this.biomeColors.hasFoliage()) {
            return this.biomeColors.getFoliage();
        }
        return super.func_225527_a_();
    }

    public boolean hasSkyFeatures() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_225529_c_() {
        if (this.biomeColors.hasSky()) {
            return this.biomeColors.getSky();
        }
        return super.func_225529_c_();
    }

    public final Vec3d alterCloudColor(Vec3d clouds) {
        if (this.biomeColors.hasClouds()) {
            float[] colors = this.biomeColors.getCloudsRGB();
            clouds = clouds.func_216372_d((double)colors[0], (double)colors[1], (double)colors[2]);
        }
        return clouds;
    }

    public final float getCloudCoverage() {
        return this.biomeColors.getCloudCoverage();
    }

    public final Vec3d alterFogColor(Vec3d fog) {
        if (this.biomeColors.hasFog()) {
            float[] colors = this.biomeColors.getFogRGB();
            fog = fog.func_216372_d((double)colors[0], (double)colors[1], (double)colors[2]);
        }
        return fog;
    }

    public final boolean isFoggy() {
        return this.biomeColors.isFoggy();
    }

    public Biome.RainType func_201851_b() {
        if (LOTRBiomeBase.isSnowEverywhereForChristmas()) {
            return Biome.RainType.SNOW;
        }
        return super.func_201851_b();
    }

    public static boolean isSnowEverywhereForChristmas() {
        return LOTRMod.proxy.isClient() && CalendarUtil.isChristmas();
    }

    public float getTemperatureForSnowWeatherRendering(IWorld world, BlockPos pos) {
        return this.func_225486_c(pos);
    }

    public static float getTemperatureForSnowWeatherRendering(Biome biome, IWorld world, BlockPos pos) {
        return biome instanceof LOTRBiomeBase ? ((LOTRBiomeBase)biome).getTemperatureForSnowWeatherRendering(world, pos) : biome.func_225486_c(pos);
    }

    public final ExtendedWeatherType getActualExtendedWeather() {
        if (LOTRBiomeBase.isSnowEverywhereForChristmas()) {
            return ExtendedWeatherType.NONE;
        }
        return this.getExtendedWeather();
    }

    protected ExtendedWeatherType getExtendedWeather() {
        return ExtendedWeatherType.NONE;
    }

    public final boolean hasCustomWaterColor() {
        return this.biomeColors.hasWater();
    }

    public final int getCustomWaterColor() {
        return this.biomeColors.getWater();
    }

    public int func_185361_o() {
        if (this.hasCustomWaterColor()) {
            return this.getCustomWaterColor();
        }
        return LOTRMod.proxy.getGeographicalWaterColorAtViewerPosition();
    }

    public LOTRBiomeBase getRiver() {
        return (LOTRBiomeBase)LOTRBiomes.RIVER.get();
    }

    public boolean isRiver() {
        return false;
    }

    public LOTRBiomeBase getShore() {
        if (this.func_185355_j() < 0.0f) {
            return this;
        }
        return (LOTRBiomeBase)LOTRBiomes.BEACH.get();
    }

    public abstract WaypointRegion getWaypointRegion();

    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.PATH;
    }

    public BridgeBlockProvider getBridgeBlockProvider() {
        return BridgeBlockProvider.OAK;
    }

    public static class CustomBiomeColors {
        private int grass = -1;
        private int foliage = -1;
        private int sky = -1;
        private int clouds = -1;
        private float[] cloudsRGB = new float[3];
        private float cloudCoverage = 1.0f;
        private int fog = -1;
        private float[] fogRGB = new float[3];
        private boolean foggy = false;
        private int water = -1;

        public boolean hasGrass() {
            return this.grass >= 0;
        }

        public int getGrass() {
            return this.grass;
        }

        public CustomBiomeColors setGrass(int i) {
            this.grass = i;
            return this;
        }

        public CustomBiomeColors resetGrass() {
            return this.setGrass(-1);
        }

        public boolean hasFoliage() {
            return this.foliage >= 0;
        }

        public int getFoliage() {
            return this.foliage;
        }

        public CustomBiomeColors setFoliage(int i) {
            this.foliage = i;
            return this;
        }

        public CustomBiomeColors resetFoliage() {
            return this.setFoliage(-1);
        }

        public boolean hasSky() {
            return this.sky >= 0;
        }

        public int getSky() {
            return this.sky;
        }

        public CustomBiomeColors setSky(int i) {
            this.sky = i;
            return this;
        }

        public CustomBiomeColors resetSky() {
            return this.setSky(-1);
        }

        public boolean hasClouds() {
            return this.clouds >= 0;
        }

        public int getClouds() {
            return this.clouds;
        }

        public float[] getCloudsRGB() {
            return this.cloudsRGB;
        }

        public CustomBiomeColors setClouds(int i) {
            this.clouds = i;
            this.cloudsRGB = new Color(this.clouds).getColorComponents(this.cloudsRGB);
            return this;
        }

        public float getCloudCoverage() {
            return this.cloudCoverage;
        }

        public CustomBiomeColors setCloudCoverage(float f) {
            this.cloudCoverage = f;
            return this;
        }

        public CustomBiomeColors resetClouds() {
            this.clouds = -1;
            this.cloudsRGB = null;
            this.cloudCoverage = 1.0f;
            return this;
        }

        public boolean hasFog() {
            return this.fog >= 0;
        }

        public int getFog() {
            return this.fog;
        }

        public float[] getFogRGB() {
            return this.fogRGB;
        }

        public CustomBiomeColors setFog(int i) {
            this.fog = i;
            this.fogRGB = new Color(this.fog).getColorComponents(this.fogRGB);
            return this;
        }

        public boolean isFoggy() {
            return this.foggy;
        }

        public CustomBiomeColors setFoggy(boolean flag) {
            this.foggy = flag;
            return this;
        }

        public CustomBiomeColors resetFog() {
            this.fog = -1;
            this.fogRGB = null;
            this.foggy = false;
            return this;
        }

        public boolean hasWater() {
            return this.water >= 0;
        }

        public int getWater() {
            return this.water;
        }

        public CustomBiomeColors setWater(int i) {
            this.water = i;
            return this;
        }

        public CustomBiomeColors resetWater(int i) {
            return this.setWater(-1);
        }
    }
}

